/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SCTE130ADIMessageFactory
implements SCTE130MessageFactory {
    private static SCTE130ADIMessageFactory instance = null;
    private String SCTE130ADIPackagePrefix = "com.ttv.SCTE130.messages.adi";

    public static synchronized SCTE130ADIMessageFactory getInstance() {
        if (instance == null) {
            instance = new SCTE130ADIMessageFactory();
        }
        return instance;
    }

    private SCTE130ADIMessageFactory() {
    }

    public Element parseRawADIDocument(byte[] content, boolean convertToADI_11) throws Exception {
        SAXDocumentBuilder builder = new SAXDocumentBuilder();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = null;
        builder.setConvertToADI11(convertToADI_11);
        parser = factory.newSAXParser();
        parser.parse((InputStream)new ByteArrayInputStream(content), (DefaultHandler)builder);
        return builder.getDocument().getDocumentElement();
    }

    public Object allocateSCTE130Message(Element element) throws Exception {
        Element targetElement = SCTE130MessageFactoryLocator.retrieveElementOfInterest(element);
        return this.allocateSCTE130ADIMessage(targetElement.getLocalName() != null ? targetElement.getLocalName() : targetElement.getNodeName(), targetElement);
    }

    private Object allocateSCTE130ADIMessage(String className, Element element) throws Exception {
        String modifiedClassName = SCTE130Utils.removeNamespace(className);
        String packageName = this.SCTE130ADIPackagePrefix + "." + modifiedClassName;
        Class<?> clazz = Class.forName(packageName);
        Constructor<?> constructor = clazz.getDeclaredConstructor(Element.class);
        Object obj = null;
        try {
            if (constructor != null) {
                obj = constructor.newInstance(element);
            }
        }
        catch (IllegalAccessException iea) {
            throw new Exception("Failed to allocate object of type: " + packageName);
        }
        return obj;
    }

    private class SAXDocumentBuilder
    extends DefaultHandler {
        private Document doc = null;
        private Stack elementStack = new Stack();
        private boolean convertToADI11 = false;
        private String error = null;

        public String getError() {
            return this.error;
        }

        public boolean isConvertToADI11() {
            return this.convertToADI11;
        }

        public void setConvertToADI11(boolean convertToADI11) {
            this.convertToADI11 = convertToADI11;
        }

        public Document getDocument() {
            return this.doc;
        }

        public void characters(char[] ch, int start, int length) {
        }

        public void startDocument() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.doc = builder.newDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void endDocument() {
        }

        public void error(SAXParseException e) {
            this.error = e.getMessage();
        }

        public void fatalError(SAXParseException e) {
            this.error = e.getMessage();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Element element = this.doc.createElementNS("http://ns1/adi", "adi:" + qName);
            element = this.isConvertToADI11() && qName.equals("ADI") ? this.doc.createElementNS("http://ns1/adi", "adi:ADI_11") : this.doc.createElementNS("http://ns1/adi", "adi:" + qName);
            for (int indx = 0; indx < attributes.getLength(); ++indx) {
                element.setAttribute(attributes.getQName(indx), attributes.getValue(indx));
            }
            if (this.elementStack.empty()) {
                this.doc.appendChild(element);
                element.setAttribute("xmlns", "http://ns1/adi");
                element.setAttribute("xmlns:adi", "http://ns1/adi");
            } else {
                ((Element)this.elementStack.peek()).appendChild(element);
            }
            this.elementStack.push(element);
        }

        public void endElement(String uri, String localName, String qName) {
            this.elementStack.pop();
        }
    }
}

