/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130;

import com.ttv.SCTE130.SCTE130ADIMessageFactory;
import com.ttv.SCTE130.SCTE130ADMMessageFactory;
import com.ttv.SCTE130.SCTE130CISMessageFactory;
import com.ttv.SCTE130.SCTE130CoreMessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.utils.SCTE130Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SCTE130MessageFactoryLocator {
    private static String NAMESPACE_CIS = "cis";
    private static String NAMESPACE_CORE = "core";
    private static String NAMESPACE_ADI = "adi";
    private static String NAMESPACE_ADM = "adm";

    public static SCTE130MessageFactory getMessageFactory(Element element) throws Exception {
        Element targetElement = SCTE130MessageFactoryLocator.retrieveElementOfInterest(element);
        if (targetElement == null) {
            SCTE130Utils.getInstance().devLog("Failed to locate SCTE130 related namespace items in element: " + element.getNodeName() + " namespace: " + element.getNamespaceURI());
            throw new Exception("Failed to locate SCTE130MessageFactory for element: " + element.getNodeName() + " namespace: " + element.getNamespaceURI());
        }
        String nameSpacePrefix = SCTE130MessageFactoryLocator.retrieveNamespacePrefix(targetElement);
        SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(nameSpacePrefix);
        if (factory != null) {
            return factory;
        }
        SCTE130Utils.getInstance().devLog("Failed to locate SCTE130MessageFactory for namespace[" + nameSpacePrefix + "]");
        throw new Exception("Failed to locate SCTE130MessageFactory for namespace[" + nameSpacePrefix + "]");
    }

    public static Element retrieveElementOfInterest(Element element) {
        String nameSpacePrefix = SCTE130MessageFactoryLocator.retrieveNamespacePrefix(element);
        if (SCTE130MessageFactoryLocator.getMessageFactory(nameSpacePrefix) != null) {
            return element;
        }
        NodeList list = element.getChildNodes();
        if (list.getLength() == 0) {
            return null;
        }
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Element ele;
            Node node = list.item(indx);
            if (!(node instanceof Element) || (ele = SCTE130MessageFactoryLocator.retrieveElementOfInterest((Element)node)) == null) continue;
            return ele;
        }
        return null;
    }

    public static String retrieveNamespacePrefix(Element element) {
        String nameSpacePrefix = null;
        if (element.getNamespaceURI() == null) {
            if (element.getNodeName().indexOf(58) != -1) {
                nameSpacePrefix = element.getNodeName().split(":")[0];
            }
        } else {
            nameSpacePrefix = SCTE130Namespaces.getInstance().getNameForURI(element.getNamespaceURI());
        }
        return nameSpacePrefix;
    }

    public static SCTE130MessageFactory getMessageFactory(String namespaceURL) {
        if (namespaceURL == null) {
            return null;
        }
        if (namespaceURL.equals(NAMESPACE_CIS)) {
            return SCTE130CISMessageFactory.getInstance();
        }
        if (namespaceURL.equals(NAMESPACE_CORE)) {
            return SCTE130CoreMessageFactory.getInstance();
        }
        if (namespaceURL.equals(NAMESPACE_ADI)) {
            return SCTE130ADIMessageFactory.getInstance();
        }
        if (namespaceURL.equals(NAMESPACE_ADM)) {
            return SCTE130ADMMessageFactory.getInstance();
        }
        return null;
    }
}

