/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adi;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.Date;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

public class AMS
implements MessageInterface {
    private String assetName = null;
    private String provider = null;
    private String product = null;
    private String assetId = null;
    private String providerId = null;
    private String description = null;
    private String assetClass = null;
    private String verb = null;
    private Date creationDate = null;
    private int versionMajor;
    private int versionMinor;
    public static String ELE_AMS = "AMS";
    public static final String ATTR_ASSET_NAME = "Asset_Name";
    public static final String ATTR_PROVIDER = "Provider";
    public static final String ATTR_PRODUCT = "Product";
    public static final String ATTR_DESCRIPTION = "Description";
    public static final String ATTR_ASSET_CLASS = "Asset_Class";
    public static final String ATTR_VERB = "Verb";
    public static final String ATTR_CREATION_DATE = "Creation_Date";
    public static final String ATTR_VERSION_MAJOR = "Version_Major";
    public static final String ATTR_VERSION_MINOR = "Version_Minor";
    public static final String ATTR_ASSET_ID = "Asset_ID";
    public static final String ATTR_PROVIDER_ID = "Provider_ID";

    public AMS(Element element) throws Exception {
        this.assetId = element.getAttribute(ATTR_ASSET_ID);
        this.providerId = element.getAttribute(ATTR_PROVIDER_ID);
        this.assetName = element.getAttribute(ATTR_ASSET_NAME);
        this.provider = element.getAttribute(ATTR_PROVIDER);
        this.product = element.getAttribute(ATTR_PRODUCT);
        this.description = element.getAttribute(ATTR_DESCRIPTION);
        this.assetClass = element.getAttribute(ATTR_ASSET_CLASS);
        this.verb = element.getAttribute(ATTR_VERB);
        String remoteCreationDate = element.getAttribute(ATTR_CREATION_DATE);
        String remoteVersionMajor = element.getAttribute(ATTR_VERSION_MAJOR);
        String remoteVersionMinor = element.getAttribute(ATTR_VERSION_MINOR);
        if (remoteCreationDate != null && remoteCreationDate.length() != 0) {
            this.creationDate = DateUtils.parseAMSDateTime(remoteCreationDate);
        }
        if (remoteVersionMajor != null && remoteVersionMajor.length() != 0) {
            this.versionMajor = Integer.parseInt(remoteVersionMajor);
        }
        if (remoteVersionMinor != null && remoteVersionMinor.length() != 0) {
            this.versionMinor = Integer.parseInt(remoteVersionMinor);
        }
    }

    public AMS(String assetId, String providerId, String assetName, String provider, String product, String description, String assetClass, String verb, Date creationDate, int versionMajor, int versionMinor) {
        this.assetId = assetId;
        this.providerId = providerId;
        this.assetName = assetName;
        this.provider = provider;
        this.product = product;
        this.description = description;
        this.assetClass = assetClass;
        this.verb = verb;
        this.versionMajor = versionMajor;
        this.versionMinor = versionMinor;
        try {
            this.creationDate = DateUtils.parseAMSDateTime(DateUtils.formatAMSDateTime(creationDate));
        }
        catch (Exception e) {
            this.creationDate = creationDate;
        }
    }

    public boolean equals(MessageInterface obj) {
        AMS other = (AMS)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getAssetId(), other.getAssetId())) {
            dUtils.devLog("AMS equality check failed. AssetIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getProviderId(), other.getProviderId())) {
            dUtils.devLog("AMS equality check failed. ProviderId don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getAssetName(), other.getAssetName())) {
            dUtils.devLog("AMS equality check failed. Asset Names don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getProvider(), other.getProvider())) {
            dUtils.devLog("AMS equality check failed. Providers don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getProduct(), other.getProduct())) {
            dUtils.devLog("AMS equality check failed. Products don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getDescription(), other.getDescription())) {
            dUtils.devLog("AMS equality check failed. Description don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getAssetClass(), other.getAssetClass())) {
            dUtils.devLog("AMS equality check failed. AssetClass don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getVerb(), other.getVerb())) {
            dUtils.devLog("AMS equality check failed. Verbs don't match.");
            return false;
        }
        if (this.getCreationDate().compareTo(other.getCreationDate()) != 0) {
            dUtils.devLog("AMS equality check failed. Creation Dates don't match.");
            return false;
        }
        if (this.getVersionMajor() != other.getVersionMajor()) {
            dUtils.devLog("AMS equality check failed. Major versions don't match.");
            return false;
        }
        if (this.getVersionMinor() != other.getVersionMinor()) {
            dUtils.devLog("AMS equality check failed. Minor versions don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement asset = factory.createElement(ELE_AMS, "adi", nameSpaces.getURIForName("adi"));
        nameSpaces.populateNamespace(asset, "adi");
        asset.setAttribute(ATTR_ASSET_ID, this.getAssetId());
        asset.setAttribute(ATTR_PROVIDER_ID, this.getProviderId());
        asset.setAttribute(ATTR_ASSET_NAME, this.getAssetName());
        asset.setAttribute(ATTR_PROVIDER, this.getProvider());
        asset.setAttribute(ATTR_PRODUCT, this.getProduct());
        asset.setAttribute(ATTR_DESCRIPTION, this.getDescription());
        asset.setAttribute(ATTR_ASSET_CLASS, this.getAssetClass());
        asset.setAttribute(ATTR_VERB, this.getVerb());
        asset.setAttribute(ATTR_CREATION_DATE, this.getCreationDateAsStr());
        asset.setAttribute(ATTR_VERSION_MAJOR, this.getVersionMajorAsStr());
        asset.setAttribute(ATTR_VERSION_MINOR, this.getVersionMinorAsStr());
        return asset;
    }

    public String getAssetClass() {
        return this.assetClass;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCreationDateAsStr() {
        return DateUtils.formatAMSDateTime(this.getCreationDate());
    }

    public String getDescription() {
        return this.description;
    }

    public String getProduct() {
        return this.product;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getVerb() {
        return this.verb;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public String getVersionMajorAsStr() {
        return "" + this.versionMajor;
    }

    public String getVersionMinorAsStr() {
        return "" + this.versionMinor;
    }
}

