/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADMCapabilities
implements MessageInterface {
    private boolean placementStatusOnlyRegistration = false;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private Ext ext = null;
    public static final String ELE_ADM_CAPABILITIES = "ADMCapabilities";
    private static final String ATTR_PLACEMENT_STATUS_ONLY_REGISTRATION = "placementStatusOnlyRegistration";
    private String[] namedAttributes = new String[]{"placementStatusOnlyRegistration"};

    public ADMCapabilities(Element element) throws Exception {
        String placementStatusOnlyRegistrationStr = element.getAttribute(ATTR_PLACEMENT_STATUS_ONLY_REGISTRATION);
        if (placementStatusOnlyRegistrationStr != null && placementStatusOnlyRegistrationStr.length() > 0) {
            this.placementStatusOnlyRegistration = Boolean.parseBoolean(placementStatusOnlyRegistrationStr);
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Element child;
            SCTE130MessageFactory factory;
            Object obj;
            Node node = list.item(indx);
            if (!(node instanceof Element) || !((obj = (factory = SCTE130MessageFactoryLocator.getMessageFactory(child = (Element)node)).allocateSCTE130Message(child)) instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public ADMCapabilities() {
    }

    public ADMCapabilities(boolean placementStatusOnlyRegistration, Ext ext) {
        this.placementStatusOnlyRegistration = placementStatusOnlyRegistration;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        ADMCapabilities other = (ADMCapabilities)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.isPlacementStatusOnlyRegistration() != other.isPlacementStatusOnlyRegistration()) {
            dUtils.devLog("ADMCapabilities equality check failed. Message Refs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("ADMCapabilities equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement notification = factory.createElement(ELE_ADM_CAPABILITIES, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(notification, "adm");
        SCTE130Utils.setAttribute(notification, ATTR_PLACEMENT_STATUS_ONLY_REGISTRATION, Boolean.toString(this.isPlacementStatusOnlyRegistration()));
        SCTE130Utils.addOtherAttributes(notification, this.anyAttributes);
        SCTE130Utils.addChildElement(notification, this.getExt());
        return notification;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public boolean isPlacementStatusOnlyRegistration() {
        return this.placementStatusOnlyRegistration;
    }

    public void setPlacementStatusOnlyRegistration(boolean placementStatusOnlyRegistration) {
        this.placementStatusOnlyRegistration = placementStatusOnlyRegistration;
    }
}

