/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentRotationList
implements MessageInterface {
    private List<Content> content = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    public static final String ELE_CONTENT_ROTATION_LIST = "ContentRotationList";

    public ContentRotationList(Element element) throws Exception {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Element child;
            SCTE130MessageFactory factory;
            Object obj;
            Node node = list.item(indx);
            if (!(node instanceof Element) || !((obj = (factory = SCTE130MessageFactoryLocator.getMessageFactory(child = (Element)node)).allocateSCTE130Message(child)) instanceof Content)) continue;
            if (this.content == null) {
                this.content = new ArrayList<Content>();
            }
            this.content.add((Content)obj);
        }
    }

    public ContentRotationList() {
    }

    public ContentRotationList(List<Content> content) {
        this.content = content;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        ContentRotationList other = (ContentRotationList)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.listsEqual(this.getContent(), other.getContent())) {
            dUtils.devLog("ContentRotationList equality check failed. Content items don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement rotation = factory.createElement(ELE_CONTENT_ROTATION_LIST, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(rotation, "adm");
        SCTE130Utils.addOtherAttributes(rotation, this.anyAttributes);
        SCTE130Utils.addChildElementList(rotation, this.getContent());
        return rotation;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public List<Content> getContent() {
        return this.content;
    }

    public void setContent(List<Content> content) {
        this.content = content;
    }
}

