/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EntertainmentNPT
implements MessageInterface {
    private String npt = null;
    private double scale;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_ENTERTAINMENT_NPT = "EntertainmentNPT";
    private static final String ATTR_SCALE = "scale";
    private String[] namedAttributes = new String[]{"scale"};

    public EntertainmentNPT(Element element) {
        String remoteScale = element.getAttribute(ATTR_SCALE);
        if (remoteScale != null && remoteScale.length() > 0) {
            this.scale = Double.parseDouble(remoteScale);
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.npt = ((Text)node).getData();
        }
    }

    public EntertainmentNPT() {
    }

    public EntertainmentNPT(String npt, double scale) {
        this.npt = npt;
        this.scale = scale;
    }

    public boolean equals(MessageInterface obj) {
        EntertainmentNPT other = (EntertainmentNPT)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (other.getNpt() != this.getNpt()) {
            dUtils.devLog("EntertainmentNPT equality check failed. NPT values don't match.");
            return false;
        }
        if (other.getScale() != this.getScale()) {
            dUtils.devLog("EntertainmentNPT equality check failed. Scales don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement nptVal = factory.createElement(ELE_ENTERTAINMENT_NPT, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(nptVal, "adm");
        SCTE130Utils.setAttribute(nptVal, ATTR_SCALE, this.getScaleAsStr());
        SCTE130Utils.addOtherAttributes(nptVal, this.anyAttributes);
        nptVal.addTextNode(this.getNpt());
        return nptVal;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getNpt() {
        return this.npt;
    }

    public void setNpt(String npt) {
        this.npt = npt;
    }

    public String getNptFrame() {
        String[] npts = this.npt.split("-");
        String firstNpt = null;
        firstNpt = npts != null && npts.length > 0 ? npts[0] : this.npt;
        if (firstNpt.indexOf(46) != -1) {
            String[] values = firstNpt.split(".");
            return values[0];
        }
        return firstNpt;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public String getScaleAsStr() {
        return "" + this.scale;
    }
}

