/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Event;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Events
implements MessageInterface {
    private Date eventRangeStartDateTime = null;
    private Date eventRangeEndDateTime = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private List<Event> events = null;
    private Ext ext = null;
    public static final String ELE_EVENTS = "Events";
    protected static final String ATTR_EVENT_START_DATE = "eventRangeStartDateTime";
    protected static final String ATTR_EVENT_END_DATE = "eventRangeEndDateTime";
    private String[] namedAttributes = new String[]{"eventRangeStartDateTime", "eventRangeEndDateTime"};

    public Events(Element element) throws Exception {
        String remoteStartDate = element.getAttribute(ATTR_EVENT_START_DATE);
        String remoteEndDate = element.getAttribute(ATTR_EVENT_END_DATE);
        if (remoteStartDate != null && remoteStartDate.length() > 0) {
            this.eventRangeStartDateTime = DateUtils.parseXSDDateTime(remoteStartDate);
        }
        if (remoteEndDate != null && remoteEndDate.length() > 0) {
            this.eventRangeEndDateTime = DateUtils.parseXSDDateTime(remoteEndDate);
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Element child;
            SCTE130MessageFactory factory;
            Object obj;
            Node node = list.item(indx);
            if (!(node instanceof Element) || !((obj = (factory = SCTE130MessageFactoryLocator.getMessageFactory(child = (Element)node)).allocateSCTE130Message(child)) instanceof Event)) continue;
            if (this.events == null) {
                this.events = new ArrayList<Event>();
            }
            this.events.add((Event)obj);
        }
    }

    public Events() {
    }

    public Events(List<Event> events, Date eventRangeStartDateTime, Date eventRangeEndDateTime, Ext ext) {
        this.events = events;
        this.eventRangeStartDateTime = eventRangeStartDateTime;
        this.eventRangeEndDateTime = eventRangeEndDateTime;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        Events other = (Events)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getEventRangeStartDateTime().compareTo(other.getEventRangeStartDateTime()) != 0) {
            dUtils.devLog("Events equality check failed. EventRangeStartDates don't match.");
            return false;
        }
        if (this.getEventRangeEndDateTime().compareTo(other.getEventRangeEndDateTime()) != 0) {
            dUtils.devLog("Events equality check failed. EventRangeEndDates don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getEvents(), other.getEvents())) {
            dUtils.devLog("Events equality check failed. Events don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Events equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement evnts = factory.createElement(ELE_EVENTS, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(evnts, "adm");
        SCTE130Utils.setAttribute(evnts, ATTR_EVENT_START_DATE, DateUtils.formatXSDDateTime(this.eventRangeStartDateTime));
        SCTE130Utils.setAttribute(evnts, ATTR_EVENT_END_DATE, DateUtils.formatXSDDateTime(this.eventRangeEndDateTime));
        SCTE130Utils.addOtherAttributes(evnts, this.anyAttributes);
        SCTE130Utils.addChildElementList(evnts, this.getEvents());
        SCTE130Utils.addChildElement(evnts, this.getExt());
        return evnts;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Date getEventRangeEndDateTime() {
        return this.eventRangeEndDateTime;
    }

    public void setEventRangeEndDateTime(Date eventRangeEndDateTime) {
        this.eventRangeEndDateTime = eventRangeEndDateTime;
    }

    public Date getEventRangeStartDateTime() {
        return this.eventRangeStartDateTime;
    }

    public void setEventRangeStartDateTime(Date eventRangeStartDateTime) {
        this.eventRangeStartDateTime = eventRangeStartDateTime;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }
}

