/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MinPlacementCount
implements MessageInterface {
    private int placements;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    public static final String ELE_MIN_PLACEMENT_COUNT = "MinPlacementCount";

    public MinPlacementCount(Element element) {
        String remotePlacements = null;
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text) || (remotePlacements = ((Text)node).getData()) == null || remotePlacements.length() <= 0) continue;
            this.placements = Integer.parseInt(remotePlacements);
        }
    }

    public MinPlacementCount() {
    }

    public MinPlacementCount(int placements) {
        this.placements = placements;
    }

    public boolean equals(MessageInterface obj) {
        MinPlacementCount other = (MinPlacementCount)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getPlacements() != other.getPlacements()) {
            dUtils.devLog("MinPlacementCount equality check failed. Placements don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement scpe = factory.createElement(ELE_MIN_PLACEMENT_COUNT, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(scpe, "adm");
        SCTE130Utils.addOtherAttributes(scpe, this.anyAttributes);
        scpe.addTextNode(this.getPlacementsAsStr());
        return scpe;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getPlacementsAsStr() {
        return "" + this.placements;
    }

    public int getPlacements() {
        return this.placements;
    }

    public void setPlacements(int placements) {
        this.placements = placements;
    }
}

