/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OpportunityBinding
implements MessageInterface {
    private String opportunityType = null;
    private int opportunityNumber;
    private int opportunitiesExpected;
    protected TreeMap<String, String> anyAttributes = new TreeMap();
    private Ext ext = null;
    public static final String ELE_OPPORTUNITY_BINDING = "OpportunityBinding";
    protected static final String ATTR_OPPORTUNITY_TYPE = "opportunityType";
    protected static final String ATTR_OPPORTUNITY_NUMBER = "opportunityNumber";
    protected static final String ATTR_OPPORTUNITY_EXPECTED = "opportunitiesExpected";
    private String[] namedAttributes = new String[]{"opportunityType", "opportunityNumber", "opportunitiesExpected"};
    public static final String OPPORTUNITY_TYPE_PREROLL = "PreRoll";
    public static final String OPPORTUNITY_TYPE_POSTROLL = "PostRoll";
    public static final String OPPORTUNITY_TYPE_INTERSTITIAL = "Interstitial";

    public OpportunityBinding(Element element) throws Exception {
        String remoteExpected = element.getAttribute(ATTR_OPPORTUNITY_EXPECTED);
        String remoteNumber = element.getAttribute(ATTR_OPPORTUNITY_NUMBER);
        if (remoteNumber != null && remoteNumber.length() > 0) {
            this.opportunityNumber = Integer.parseInt(remoteNumber);
        }
        if (remoteExpected != null && remoteExpected.length() > 0) {
            this.opportunitiesExpected = Integer.parseInt(remoteExpected);
        }
        this.opportunityType = element.getAttribute(ATTR_OPPORTUNITY_TYPE);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Element child;
            SCTE130MessageFactory factory;
            Object obj;
            Node node = list.item(indx);
            if (!(node instanceof Element) || !((obj = (factory = SCTE130MessageFactoryLocator.getMessageFactory(child = (Element)node)).allocateSCTE130Message(child)) instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public OpportunityBinding() {
    }

    public OpportunityBinding(String opportunityType, int opportunityNumber, int opportunitiesExpected) {
        this.opportunityType = opportunityType;
        this.opportunityNumber = opportunityNumber;
        this.opportunitiesExpected = opportunitiesExpected;
    }

    public boolean equals(MessageInterface obj) {
        OpportunityBinding other = (OpportunityBinding)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(other.getOpportunityType(), this.getOpportunityType())) {
            dUtils.devLog("OpportunityBinding equality check failed. Opportunity types don't match.");
            return false;
        }
        if (this.getOpportunitiesExpected() != other.getOpportunitiesExpected()) {
            dUtils.devLog("OpportunityBinding equality check failed. OpportunitiesExpected don't match.");
            return false;
        }
        if (this.getOpportunityNumber() != other.getOpportunityNumber()) {
            dUtils.devLog("OpportunityBinding equality check failed. OpportunityNumbers don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement oppy = factory.createElement(ELE_OPPORTUNITY_BINDING, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(oppy, "adm");
        SCTE130Utils.setAttribute(oppy, ATTR_OPPORTUNITY_TYPE, this.getOpportunityType());
        SCTE130Utils.setAttribute(oppy, ATTR_OPPORTUNITY_NUMBER, this.getOpportunityNumberAsStr());
        SCTE130Utils.setAttribute(oppy, ATTR_OPPORTUNITY_EXPECTED, this.getOpportunitiesExpectedAsStr());
        SCTE130Utils.addOtherAttributes(oppy, this.anyAttributes);
        SCTE130Utils.addChildElement(oppy, this.getExt());
        return oppy;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public int getOpportunitiesExpected() {
        return this.opportunitiesExpected;
    }

    public String getOpportunitiesExpectedAsStr() {
        return "" + this.opportunitiesExpected;
    }

    public void setOpportunitiesExpected(int opportunitiesExpected) {
        this.opportunitiesExpected = opportunitiesExpected;
    }

    public int getOpportunityNumber() {
        return this.opportunityNumber;
    }

    public String getOpportunityNumberAsStr() {
        return "" + this.opportunityNumber;
    }

    public void setOpportunityNumber(int opportunityNumber) {
        this.opportunityNumber = opportunityNumber;
    }

    public String getOpportunityType() {
        return this.opportunityType;
    }

    public void setOpportunityType(String opportunityType) {
        this.opportunityType = opportunityType;
    }
}

