/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.ContentRotationList;
import com.ttv.SCTE130.messages.adm.PlacementConstraints;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.Tracking;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Placement
implements MessageInterface {
    private String id = null;
    private String action = null;
    private String placementControlRef = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private int position;
    private Tracking tracking = null;
    private Content content = null;
    private ContentRotationList rotationList = null;
    private PlacementConstraints placementConstraints = null;
    private Ext ext = null;
    public static final String ELE_PLACEMENT = "Placement";
    private static final String ATTR_ID = "id";
    private static final String ATTR_PC_REF = "placementControlRef";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_POSITION = "position";
    private String[] namedAttributes = new String[]{"id", "placementControlRef", "action", "position"};

    public Placement(Element element) throws Exception {
        String remotePosition = element.getAttribute(ATTR_POSITION);
        if (remotePosition != null && remotePosition.length() > 0) {
            this.position = Integer.parseInt(remotePosition);
        }
        this.id = element.getAttribute(ATTR_ID);
        this.action = element.getAttribute(ATTR_ACTION);
        this.placementControlRef = element.getAttribute(ATTR_PC_REF);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Tracking) {
                this.tracking = (Tracking)obj;
            }
            if (obj instanceof Content) {
                this.content = (Content)obj;
            }
            if (obj instanceof ContentRotationList) {
                this.rotationList = (ContentRotationList)obj;
            }
            if (obj instanceof PlacementConstraints) {
                this.placementConstraints = (PlacementConstraints)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public Placement() {
    }

    public Placement(String id, String action, String placementControlRef, int position, Tracking tracking, Content content, PlacementConstraints placementConstraints, Ext ext) {
        this.id = id;
        this.action = action;
        this.placementControlRef = placementControlRef;
        this.position = position;
        this.tracking = tracking;
        this.content = content;
        this.rotationList = null;
        this.placementConstraints = placementConstraints;
        this.ext = ext;
    }

    public Placement(String id, String action, String placementControlRef, int position, Tracking tracking, ContentRotationList rotationList, PlacementConstraints placementConstraints, Ext ext) {
        this.id = id;
        this.action = action;
        this.placementControlRef = placementControlRef;
        this.position = position;
        this.tracking = tracking;
        this.content = null;
        this.rotationList = rotationList;
        this.placementConstraints = placementConstraints;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        Placement other = (Placement)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (other.getPosition() != this.getPosition()) {
            dUtils.devLog("Placement equality check failed. Positions don't match.");
            return false;
        }
        if (!other.getId().equals(this.getId())) {
            dUtils.devLog("Placement equality check failed. IDs don't match.");
            return false;
        }
        if (!other.getPlacementControlRef().equals(this.getPlacementControlRef())) {
            dUtils.devLog("Placement equality check failed. PlacementControlRefs don't match.");
            return false;
        }
        if (!other.getAction().equals(this.getAction())) {
            dUtils.devLog("Placement equality check failed. Actions don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getTracking(), other.getTracking())) {
            dUtils.devLog("Placement equality check failed. Tracking don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getContent(), other.getContent())) {
            dUtils.devLog("Placement equality check failed. Contents don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getRotationList(), other.getRotationList())) {
            dUtils.devLog("Placement equality check failed. RotationLists don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getPlacementConstraints(), other.getPlacementConstraints())) {
            dUtils.devLog("Placement equality check failed. PlacementConstraints don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Placement equality check failed. Exts don't match.");
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            dUtils.devLog("Placement equality check failed. Positions don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement content = factory.createElement(ELE_PLACEMENT, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(content, "adm");
        SCTE130Utils.setAttribute(content, ATTR_ID, this.getId());
        SCTE130Utils.setAttribute(content, ATTR_POSITION, this.getPositionAsStr());
        SCTE130Utils.setAttribute(content, ATTR_ACTION, this.getAction());
        SCTE130Utils.setAttribute(content, ATTR_PC_REF, this.getPlacementControlRef());
        SCTE130Utils.addOtherAttributes(content, this.anyAttributes);
        SCTE130Utils.addChildElement(content, this.getTracking());
        SCTE130Utils.addChildElement(content, this.getContent());
        SCTE130Utils.addChildElement(content, this.getRotationList());
        SCTE130Utils.addChildElement(content, this.getPlacementConstraints());
        SCTE130Utils.addChildElement(content, this.getExt());
        return content;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public PlacementConstraints getPlacementConstraints() {
        return this.placementConstraints;
    }

    public void setPlacementConstraints(PlacementConstraints placementConstraints) {
        this.placementConstraints = placementConstraints;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPlacementControlRef() {
        return this.placementControlRef;
    }

    public void setPlacementControlRef(String placementControlRef) {
        this.placementControlRef = placementControlRef;
    }

    public int getPosition() {
        return this.position;
    }

    public String getPositionAsStr() {
        return "" + this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public ContentRotationList getRotationList() {
        return this.rotationList;
    }

    public void setRotationList(ContentRotationList rotationList) {
        this.rotationList = rotationList;
    }

    public Tracking getTracking() {
        return this.tracking;
    }

    public void setTracking(Tracking tracking) {
        this.tracking = tracking;
    }
}

