/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.OpportunityConstraints;
import com.ttv.SCTE130.messages.adm.PlacementDateTime;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PlacementControl
implements MessageInterface {
    private String id = null;
    private String action = null;
    private int position;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private Content content = null;
    private OpportunityConstraints constraints = null;
    private PlacementDateTime placementDateTime = null;
    private Ext ext = null;
    public static final String ELE_PLACEMENT_CONTROL = "PlacementControl";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_POSITION = "position";
    private String[] namedAttributes = new String[]{"id", "action", "position"};
    public static final String ACTION_DELETE = "Delete";
    public static final String ACTION_FILL = "Fill";
    public static final String ACTION_FIXED = "Fixed";
    public static final String ACTION_REPLACE = "Replace";

    public PlacementControl(Element element) throws Exception {
        String remotePosition = element.getAttribute(ATTR_POSITION);
        if (remotePosition != null && remotePosition.length() > 0) {
            this.position = Integer.parseInt(remotePosition);
        }
        this.id = element.getAttribute(ATTR_ID);
        this.action = element.getAttribute(ATTR_ACTION);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Content) {
                this.content = (Content)obj;
            }
            if (obj instanceof OpportunityConstraints) {
                this.constraints = (OpportunityConstraints)obj;
            }
            if (obj instanceof PlacementDateTime) {
                this.placementDateTime = (PlacementDateTime)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public PlacementControl() {
    }

    public PlacementControl(String id, String action, int position, Content content, OpportunityConstraints constraints, PlacementDateTime placementDateTime, Ext ext) {
        this.id = id;
        this.action = action;
        this.position = position;
        this.content = content;
        this.constraints = constraints;
        this.placementDateTime = placementDateTime;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        PlacementControl other = (PlacementControl)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (other.getPosition() != this.getPosition()) {
            dUtils.devLog("PlacementControl equality check failed. ONums don't match.");
            return false;
        }
        if (!other.getId().equals(this.getId())) {
            dUtils.devLog("PlacementControl equality check failed. IDs don't match.");
            return false;
        }
        if (!other.getAction().equals(this.getAction())) {
            dUtils.devLog("PlacementControl equality check failed. Actions don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getContent(), other.getContent())) {
            dUtils.devLog("PlacementControl equality check failed. Contents don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getConstraints(), other.getConstraints())) {
            dUtils.devLog("PlacementControl equality check failed. Constraints don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getPlacementDateTime(), other.getPlacementDateTime())) {
            dUtils.devLog("PlacementControl equality check failed. PlacementDateTimes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("PlacementControl equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement content = factory.createElement(ELE_PLACEMENT_CONTROL, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(content, "adm");
        SCTE130Utils.setAttribute(content, ATTR_ID, this.getId());
        SCTE130Utils.setAttribute(content, ATTR_POSITION, this.getPositionAsStr());
        SCTE130Utils.setAttribute(content, ATTR_ACTION, this.getAction());
        SCTE130Utils.addOtherAttributes(content, this.anyAttributes);
        SCTE130Utils.addChildElement(content, this.getContent());
        SCTE130Utils.addChildElement(content, this.getConstraints());
        SCTE130Utils.addChildElement(content, this.getPlacementDateTime());
        SCTE130Utils.addChildElement(content, this.getExt());
        return content;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public OpportunityConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(OpportunityConstraints constraints) {
        this.constraints = constraints;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PlacementDateTime getPlacementDateTime() {
        return this.placementDateTime;
    }

    public void setPlacementDateTime(PlacementDateTime placementDateTime) {
        this.placementDateTime = placementDateTime;
    }

    public int getPosition() {
        return this.position;
    }

    public String getPositionAsStr() {
        return "" + this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }
}

