/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PlacementDateTime
implements MessageInterface {
    private Date time = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    public static final String ELE_PLACEMENT_DATE_TIME = "PlacementDateTime";

    public PlacementDateTime(Element element) throws Exception {
        String remoteTime = null;
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text) || (remoteTime = ((Text)node).getData()) == null || remoteTime.length() <= 0) continue;
            this.time = DateUtils.parseXSDDateTime(remoteTime);
        }
    }

    public PlacementDateTime() {
    }

    public PlacementDateTime(Date time) {
        this.time = time;
    }

    public boolean equals(MessageInterface obj) {
        PlacementDateTime other = (PlacementDateTime)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (other.getTime().compareTo(this.getTime()) != 0) {
            dUtils.devLog("PlacementDateTime equality check failed. Dates don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement addr = factory.createElement(ELE_PLACEMENT_DATE_TIME, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(addr, "adm");
        SCTE130Utils.addOtherAttributes(addr, this.anyAttributes);
        addr.addTextNode(this.getTimeAsStr());
        return addr;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Date getTime() {
        return this.time;
    }

    public String getTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.time);
    }

    public void setTime(Date time) {
        this.time = time;
    }
}

