/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.OpportunityBinding;
import com.ttv.SCTE130.messages.adm.Placement;
import com.ttv.SCTE130.messages.adm.PlacementConstraints;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementDecision
implements MessageInterface {
    private String id = null;
    private String placementOpportunityRef = null;
    private String localServiceRef = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private Entertainment entertainment = null;
    private OpportunityBinding opportunityBinding = null;
    private PlacementConstraints constraints = null;
    private List<Placement> placements = null;
    private Ext ext = null;
    public static final String ELE_PLACEMENT_DECISION = "PlacementDecision";
    private static final String ATTR_ID = "id";
    private static final String ATTR_PLACEMENT_OPPORTUNITY_REF = "placementOpportunityRef";
    private static final String ATTR_LOCAL_SERVICE_REF = "localServiceRef";
    private String[] namedAttributes = new String[]{"id", "placementOpportunityRef", "localServiceRef"};

    public PlacementDecision(Element element) throws Exception {
        this.id = element.getAttribute(ATTR_ID);
        this.placementOpportunityRef = element.getAttribute(ATTR_PLACEMENT_OPPORTUNITY_REF);
        this.localServiceRef = element.getAttribute(ATTR_LOCAL_SERVICE_REF);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Entertainment) {
                this.entertainment = (Entertainment)obj;
            }
            if (obj instanceof OpportunityBinding) {
                this.opportunityBinding = (OpportunityBinding)obj;
            }
            if (obj instanceof PlacementConstraints) {
                this.constraints = (PlacementConstraints)obj;
            }
            if (obj instanceof Placement) {
                if (this.placements == null) {
                    this.placements = new ArrayList<Placement>();
                }
                this.placements.add((Placement)obj);
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public PlacementDecision() {
    }

    public PlacementDecision(String id, String placementOpportunityRef, String localServiceRef, OpportunityBinding opportunityBinding, PlacementConstraints constraints, List<Placement> placements, Ext ext) {
        this.id = id;
        this.placementOpportunityRef = placementOpportunityRef;
        this.localServiceRef = localServiceRef;
        this.opportunityBinding = opportunityBinding;
        this.constraints = constraints;
        this.placements = placements;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        PlacementDecision other = (PlacementDecision)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getId(), other.getId())) {
            dUtils.devLog("PlacementDecision equality check failed. Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getPlacementOpportunityRef(), other.getPlacementOpportunityRef())) {
            dUtils.devLog("PlacementDecision equality check failed. PlacementOpportunityRefs don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getLocalServiceRef(), other.getLocalServiceRef())) {
            dUtils.devLog("PlacementDecision equality check failed. LocalServiceRefs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEntertainment(), other.getEntertainment())) {
            dUtils.devLog("PlacementDecision equality check failed. Entertainment don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getOpportunityBinding(), other.getOpportunityBinding())) {
            dUtils.devLog("PlacementDecision equality check failed. OpportunityBindings don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getConstraints(), other.getConstraints())) {
            dUtils.devLog("PlacementDecision equality check failed. PlacementConstraints don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getPlacements(), other.getPlacements())) {
            dUtils.devLog("PlacementDecision equality check failed. Placement Items don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("PlacementRequest equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement placement = factory.createElement(ELE_PLACEMENT_DECISION, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(placement, "adm");
        SCTE130Utils.setAttribute(placement, ATTR_ID, this.getId());
        SCTE130Utils.setAttribute(placement, ATTR_PLACEMENT_OPPORTUNITY_REF, this.getPlacementOpportunityRef());
        SCTE130Utils.setAttribute(placement, ATTR_LOCAL_SERVICE_REF, this.getLocalServiceRef());
        SCTE130Utils.addOtherAttributes(placement, this.anyAttributes);
        SCTE130Utils.addChildElement(placement, this.getEntertainment());
        SCTE130Utils.addChildElement(placement, this.getOpportunityBinding());
        SCTE130Utils.addChildElement(placement, this.getConstraints());
        SCTE130Utils.addChildElementList(placement, this.getPlacements());
        SCTE130Utils.addChildElement(placement, this.getExt());
        return placement;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Entertainment getEntertainment() {
        return this.entertainment;
    }

    public void setEntertainment(Entertainment entertainment) {
        this.entertainment = entertainment;
    }

    public String getLocalServiceRef() {
        return this.localServiceRef;
    }

    public void setLocalServiceRef(String localServiceRef) {
        this.localServiceRef = localServiceRef;
    }

    public PlacementConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(PlacementConstraints constraints) {
        this.constraints = constraints;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OpportunityBinding getOpportunityBinding() {
        return this.opportunityBinding;
    }

    public void setOpportunityBinding(OpportunityBinding opportunityBinding) {
        this.opportunityBinding = opportunityBinding;
    }

    public String getPlacementOpportunityRef() {
        return this.placementOpportunityRef;
    }

    public void setPlacementOpportunityRef(String placementOpportunityRef) {
        this.placementOpportunityRef = placementOpportunityRef;
    }

    public List<Placement> getPlacements() {
        return this.placements;
    }

    public void setPlacements(List<Placement> placements) {
        this.placements = placements;
    }
}

