/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.OpportunityBinding;
import com.ttv.SCTE130.messages.adm.OpportunityConstraints;
import com.ttv.SCTE130.messages.adm.PlacementControl;
import com.ttv.SCTE130.messages.adm.PlacementDateTime;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementOpportunity
implements MessageInterface {
    private String id = null;
    private String serviceRegistrationRef = null;
    private String localServiceRef = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private Entertainment entertainment = null;
    private OpportunityBinding opportunityBinding = null;
    private OpportunityConstraints constraints = null;
    private PlacementDateTime placementDateTime = null;
    private List<PlacementControl> placementControls = null;
    private Ext ext = null;
    public static final String ELE_PLACEMENT_OPPORTUNITY = "PlacementOpportunity";
    private static final String ATTR_ID = "id";
    private static final String ATTR_SERVICE_REGISTRATION_REF = "serviceRegistrationRef";
    private static final String ATTR_LOCAL_SERVICE_REF = "localServiceRef";
    private String[] namedAttributes = new String[]{"id", "serviceRegistrationRef", "localServiceRef"};

    public PlacementOpportunity(Element element) throws Exception {
        this.id = element.getAttribute(ATTR_ID);
        this.serviceRegistrationRef = element.getAttribute(ATTR_SERVICE_REGISTRATION_REF);
        this.localServiceRef = element.getAttribute(ATTR_LOCAL_SERVICE_REF);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Entertainment) {
                this.entertainment = (Entertainment)obj;
            }
            if (obj instanceof OpportunityBinding) {
                this.opportunityBinding = (OpportunityBinding)obj;
            }
            if (obj instanceof OpportunityConstraints) {
                this.constraints = (OpportunityConstraints)obj;
            }
            if (obj instanceof PlacementDateTime) {
                this.placementDateTime = (PlacementDateTime)obj;
            }
            if (obj instanceof PlacementControl) {
                if (this.placementControls == null) {
                    this.placementControls = new ArrayList<PlacementControl>();
                }
                this.placementControls.add((PlacementControl)obj);
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public PlacementOpportunity() {
    }

    public PlacementOpportunity(String id, String serviceRegistrationRef, String localServiceRef, OpportunityBinding opportunityBinding, OpportunityConstraints constraints, PlacementDateTime placementDateTime, List<PlacementControl> placementControls, Ext ext) {
        this.id = id;
        this.serviceRegistrationRef = serviceRegistrationRef;
        this.localServiceRef = localServiceRef;
        this.opportunityBinding = opportunityBinding;
        this.constraints = constraints;
        this.placementDateTime = placementDateTime;
        this.placementControls = placementControls;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        PlacementOpportunity other = (PlacementOpportunity)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getId(), other.getId())) {
            dUtils.devLog("PlacementOpportunity equality check failed. Message Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getConstraints(), other.getConstraints())) {
            dUtils.devLog("PlacementOpportunity equality check failed. Constraints don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getPlacementDateTime(), other.getPlacementDateTime())) {
            dUtils.devLog("PlacementOpportunity equality check failed. PlacementDateTimes don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getPlacementControls(), other.getPlacementControls())) {
            dUtils.devLog("PlacementRequest equality check failed. PlacementControl Items don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("PlacementRequest equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement placement = factory.createElement(ELE_PLACEMENT_OPPORTUNITY, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(placement, "adm");
        SCTE130Utils.setAttribute(placement, ATTR_ID, this.getId());
        SCTE130Utils.setAttribute(placement, ATTR_SERVICE_REGISTRATION_REF, this.getServiceRegistrationRef());
        SCTE130Utils.setAttribute(placement, ATTR_LOCAL_SERVICE_REF, this.getLocalServiceRef());
        SCTE130Utils.addOtherAttributes(placement, this.anyAttributes);
        SCTE130Utils.addChildElement(placement, this.getEntertainment());
        SCTE130Utils.addChildElement(placement, this.getOpportunityBinding());
        SCTE130Utils.addChildElement(placement, this.getConstraints());
        SCTE130Utils.addChildElement(placement, this.getPlacementDateTime());
        SCTE130Utils.addChildElementList(placement, this.getPlacementControls());
        SCTE130Utils.addChildElement(placement, this.getExt());
        return placement;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Entertainment getEntertainment() {
        return this.entertainment;
    }

    public void setEntertainment(Entertainment entertainment) {
        this.entertainment = entertainment;
    }

    public OpportunityConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(OpportunityConstraints constraints) {
        this.constraints = constraints;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLocalServiceRef() {
        return this.localServiceRef;
    }

    public void setLocalServiceRef(String localServiceRef) {
        this.localServiceRef = localServiceRef;
    }

    public OpportunityBinding getOpportunityBinding() {
        return this.opportunityBinding;
    }

    public void setOpportunityBinding(OpportunityBinding opportunityBinding) {
        this.opportunityBinding = opportunityBinding;
    }

    public List<PlacementControl> getPlacementControls() {
        return this.placementControls;
    }

    public void setPlacementControls(List<PlacementControl> placementControls) {
        this.placementControls = placementControls;
    }

    public PlacementDateTime getPlacementDateTime() {
        return this.placementDateTime;
    }

    public void setPlacementDateTime(PlacementDateTime placementDateTime) {
        this.placementDateTime = placementDateTime;
    }

    public String getServiceRegistrationRef() {
        return this.serviceRegistrationRef;
    }

    public void setServiceRegistrationRef(String serviceRegistrationRef) {
        this.serviceRegistrationRef = serviceRegistrationRef;
    }
}

