/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.adm.Event;
import com.ttv.SCTE130.messages.adm.PlacementStatusEvent;
import com.ttv.SCTE130.messages.adm.PlayData;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementStatusNotification
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String resend = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private List<PlayData> playData = null;
    private Ext ext = null;
    public static final String ELE_PLACEMENT_STATUS_NOTIFICATION = "PlacementStatusNotification";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_IDENTITY = "identity";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_RESEND = "resend";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "resend"};

    public PlacementStatusNotification(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.resend = element.getAttribute(ATTR_RESEND);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof PlayData) {
                if (this.playData == null) {
                    this.playData = new ArrayList<PlayData>();
                }
                this.playData.add((PlayData)obj);
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public PlacementStatusNotification() {
    }

    public PlacementStatusNotification(String messageId, String identity, String system, List<PlayData> playData, Ext ext) {
        this.messageId = messageId;
        this.identity = identity;
        this.system = system;
        this.playData = playData;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        PlacementStatusNotification other = (PlacementStatusNotification)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("PlacementStatusNotification equality check failed. Message Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("PlacementStatusNotification equality check failed. Message identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("PlacementStatusNotification equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getResend(), other.getResend())) {
            dUtils.devLog("PlacementStatusNotification equality check failed. Resend don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getPlayData(), other.getPlayData())) {
            dUtils.devLog("PlacementStatusNotification equality check failed. PlayData items don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("PlacementStatusNotification equality check failed. InitatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("PlacementStatusNotification equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement notification = factory.createElement(ELE_PLACEMENT_STATUS_NOTIFICATION, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(notification, "adm");
        SCTE130Utils.setAttribute(notification, ATTR_MESSAGE_ID, this.getMessageId());
        SCTE130Utils.setAttribute(notification, ATTR_VERSION, this.getVersion());
        SCTE130Utils.setAttribute(notification, ATTR_IDENTITY, this.getIdentity());
        SCTE130Utils.setAttribute(notification, ATTR_SYSTEM, this.getSystem());
        SCTE130Utils.setAttribute(notification, ATTR_RESEND, this.getResend());
        SCTE130Utils.addOtherAttributes(notification, this.anyAttributes);
        SCTE130Utils.addChildElement(notification, this.getInitData());
        SCTE130Utils.addChildElementList(notification, this.getPlayData());
        SCTE130Utils.addChildElement(notification, this.getExt());
        return notification;
    }

    public List<PlacementStatusEvent> getPlacementStatusEvents() {
        ArrayList<PlacementStatusEvent> pdEvents = new ArrayList<PlacementStatusEvent>();
        for (PlayData pd : this.playData) {
            List<Event> events = pd.getEvents().getEvents();
            for (Event event : events) {
                if (!(event instanceof PlacementStatusEvent)) continue;
                pdEvents.add((PlacementStatusEvent)event);
            }
        }
        return pdEvents;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    @Override
    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getResend() {
        return this.resend;
    }

    public void setResend(String resend) {
        this.resend = resend;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public List<PlayData> getPlayData() {
        return this.playData;
    }

    public String getSystem() {
        return this.system;
    }

    public String getVersion() {
        return this.version;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setPlayData(List<PlayData> playData) {
        this.playData = playData;
    }

    public void setSystem(String system) {
        this.system = system;
    }
}

