/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.EntertainmentScopedEvents;
import com.ttv.SCTE130.messages.adm.Events;
import com.ttv.SCTE130.messages.adm.SpotScopedEvents;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayData
implements MessageInterface {
    private String identityADM = null;
    private String systemADM = null;
    private String identityADS = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private Date eventRangeStartDateTime = null;
    private Date eventRangeEndDateTime = null;
    private SystemContext systemContext = null;
    private Client client = null;
    private List<EntertainmentScopedEvents> entertainmentEvents = null;
    private List<SpotScopedEvents> spotEvents = null;
    private Events events = null;
    private Ext ext = null;
    public static final String ELE_PLAY_DATA = "PlayData";
    private static final String ATTR_SYSTEM_ADM = "systemADM";
    private static final String ATTR_IDENTITY_ADM = "identityADM";
    private static final String ATTR_IDENTITY_ADS = "identityADS";
    private static final String ATTR_EVENT_RANGE_START = "eventRangeStartDateTime";
    private static final String ATTR_EVENT_RANGE_END = "eventRangeEndDateTime";
    private String[] namedAttributes = new String[]{"systemADM", "identityADM", "identityADS", "eventRangeStartDateTime", "eventRangeEndDateTime"};

    public PlayData(Element element) throws Exception {
        this.identityADM = element.getAttribute(ATTR_IDENTITY_ADM);
        this.systemADM = element.getAttribute(ATTR_SYSTEM_ADM);
        this.identityADS = element.getAttribute(ATTR_IDENTITY_ADS);
        String remoteEventRangeStart = element.getAttribute(ATTR_EVENT_RANGE_START);
        String remoteEventRangeEnd = element.getAttribute(ATTR_EVENT_RANGE_END);
        if (remoteEventRangeStart != null && remoteEventRangeStart.length() > 0) {
            try {
                this.eventRangeStartDateTime = DateUtils.parseXSDDateTime(remoteEventRangeStart);
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to parse StartTime in PlayData.");
            }
        }
        if (remoteEventRangeEnd != null && remoteEventRangeEnd.length() > 0) {
            try {
                this.eventRangeEndDateTime = DateUtils.parseXSDDateTime(remoteEventRangeEnd);
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to parse EndTime in PlayData.");
            }
        }
        this.entertainmentEvents = new ArrayList<EntertainmentScopedEvents>();
        this.spotEvents = new ArrayList<SpotScopedEvents>();
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof SystemContext) {
                this.systemContext = (SystemContext)obj;
            }
            if (obj instanceof Client) {
                this.client = (Client)obj;
            }
            if (obj instanceof EntertainmentScopedEvents) {
                this.entertainmentEvents.add((EntertainmentScopedEvents)obj);
            }
            if (obj instanceof SpotScopedEvents) {
                this.spotEvents.add((SpotScopedEvents)obj);
            }
            if (obj instanceof Events) {
                this.events = (Events)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public PlayData() {
    }

    public PlayData(String identityADM, String systemADM, String identityADS, Date eventRangeStart, Date eventRangeEnd, SystemContext systemContext, Client client, List<EntertainmentScopedEvents> entertainmentEvents, List<SpotScopedEvents> spotEvents, Events events, Ext ext) {
        this.identityADM = identityADM;
        this.systemADM = systemADM;
        this.identityADS = identityADS;
        this.eventRangeStartDateTime = eventRangeStart;
        this.eventRangeEndDateTime = eventRangeEnd;
        this.client = client;
        this.systemContext = systemContext;
        this.entertainmentEvents = entertainmentEvents;
        this.spotEvents = spotEvents;
        this.events = events;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        PlayData other = (PlayData)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getIdentityADM(), other.getIdentityADM())) {
            dUtils.devLog("PlayData equality check failed. ADM Identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystemADM(), other.getSystemADM())) {
            dUtils.devLog("PlayData equality check failed. ADM Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentityADS(), other.getIdentityADS())) {
            dUtils.devLog("PlayData equality check failed. ADS Identities don't match.");
            return false;
        }
        if (this.getEventRangeStartDateTime().compareTo(other.getEventRangeStartDateTime()) != 0) {
            dUtils.devLog("PlayData equality check failed. EventRange StartTimes don't match.");
            return false;
        }
        if (this.getEventRangeEndDateTime().compareTo(other.getEventRangeEndDateTime()) != 0) {
            dUtils.devLog("PlayData equality check failed. EventRange EndTimes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSystemContext(), other.getSystemContext())) {
            dUtils.devLog("PlayData equality check failed. SystemContexts don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getClient(), other.getClient())) {
            dUtils.devLog("PlayData equality check failed. Clients don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getEntertainmentEvents(), other.getEntertainmentEvents())) {
            dUtils.devLog("PlayData equality check failed. EntertainmentScopedEvents don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getSpotEvents(), other.getSpotEvents())) {
            dUtils.devLog("PlayData equality check failed. SpotScopedEvents don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEvents(), other.getEvents())) {
            dUtils.devLog("PlayData equality check failed. Events don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("PlayData equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement playData = factory.createElement(ELE_PLAY_DATA, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(playData, "adm");
        SCTE130Utils.setAttribute(playData, ATTR_IDENTITY_ADM, this.getIdentityADM());
        SCTE130Utils.setAttribute(playData, ATTR_SYSTEM_ADM, this.getSystemADM());
        SCTE130Utils.setAttribute(playData, ATTR_IDENTITY_ADS, this.getIdentityADS());
        SCTE130Utils.setAttribute(playData, ATTR_EVENT_RANGE_START, this.getEventRangeStartDateTimeAsStr());
        SCTE130Utils.setAttribute(playData, ATTR_EVENT_RANGE_END, this.getEventRangeEndDateTimeAsStr());
        SCTE130Utils.addOtherAttributes(playData, this.anyAttributes);
        SCTE130Utils.addChildElement(playData, this.getSystemContext());
        SCTE130Utils.addChildElement(playData, this.getClient());
        SCTE130Utils.addChildElementList(playData, this.getEntertainmentEvents());
        SCTE130Utils.addChildElementList(playData, this.getSpotEvents());
        SCTE130Utils.addChildElement(playData, this.getEvents());
        SCTE130Utils.addChildElement(playData, this.getExt());
        return playData;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public List<EntertainmentScopedEvents> getEntertainmentEvents() {
        return this.entertainmentEvents;
    }

    public void setEntertainmentEvents(List<EntertainmentScopedEvents> entertainmentEvents) {
        this.entertainmentEvents = entertainmentEvents;
    }

    public String getIdentityADS() {
        return this.identityADS;
    }

    public void setIdentityADS(String identityADS) {
        this.identityADS = identityADS;
    }

    public List<SpotScopedEvents> getSpotEvents() {
        return this.spotEvents;
    }

    public void setSpotEvents(List<SpotScopedEvents> spotEvents) {
        this.spotEvents = spotEvents;
    }

    public SystemContext getSystemContext() {
        return this.systemContext;
    }

    public void setSystemContext(SystemContext systemContext) {
        this.systemContext = systemContext;
    }

    public Date getEventRangeEndDateTime() {
        return this.eventRangeEndDateTime;
    }

    public String getEventRangeEndDateTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.eventRangeEndDateTime);
    }

    public void setEventRangeEndDateTime(Date eventRangeEndDateTime) {
        this.eventRangeEndDateTime = eventRangeEndDateTime;
    }

    public Date getEventRangeStartDateTime() {
        return this.eventRangeStartDateTime;
    }

    public String getEventRangeStartDateTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.eventRangeStartDateTime);
    }

    public void setEventRangeStartDateTime(Date eventRangeStartDateTime) {
        this.eventRangeStartDateTime = eventRangeStartDateTime;
    }

    public String getIdentityADM() {
        return this.identityADM;
    }

    public void setIdentityADM(String identityADM) {
        this.identityADM = identityADM;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public Events getEvents() {
        return this.events;
    }

    public void setEvents(Events events) {
        this.events = events;
    }

    public String getSystemADM() {
        return this.systemADM;
    }

    public void setSystemADM(String systemADM) {
        this.systemADM = systemADM;
    }
}

