/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Scope
implements MessageInterface {
    private String scope = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    public static final String SCOPE_NATIONAL = "National";
    public static final String SCOPE_REGIONAL = "Regional";
    public static final String SCOPE_LOCAL = "Local";
    public static final String SCOPE_PROVIDER = "Provider";
    public static final String SCOPE_DISTRIBUTOR = "Distributor";
    public static final String ELE_SCOPE = "Scope";

    public Scope(Element element) {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Text)) continue;
            this.scope = ((Text)node).getData();
        }
    }

    public Scope() {
    }

    public Scope(String scope) {
        this.scope = scope;
    }

    public boolean equals(MessageInterface obj) {
        Scope other = (Scope)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(other.getScope(), this.getScope())) {
            dUtils.devLog("Scope equality check failed. Scopes don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement scpe = factory.createElement(ELE_SCOPE, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(scpe, "adm");
        SCTE130Utils.addOtherAttributes(scpe, this.anyAttributes);
        scpe.addTextNode(this.getScope());
        return scpe;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

