/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.ContentProvider;
import com.ttv.SCTE130.messages.adm.PlacementDecisionOwner;
import com.ttv.SCTE130.messages.adm.ProductType;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.Program;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Service
implements MessageInterface {
    private String id = null;
    private String decisionPolicy = null;
    private String opportunityType = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private Program program = null;
    private AdType adType = null;
    private ContentProvider provider = null;
    private ProductType productType = null;
    private PlacementDecisionOwner owner = null;
    private Scope scope = null;
    private Ext ext = null;
    public static final String ELE_SERVICE = "Service";
    private static final String ATTR_ID = "id";
    private static final String ATTR_DECISION_POLICY = "decisionPolicy";
    private static final String ATTR_OPPORTUNITY_TYPE = "opportunityType";
    private String[] namedAttributes = new String[]{"id", "decisionPolicy", "opportunityType"};
    public static final String DECISION_POLICY_DEFAULT = "default";
    public static final String DECISION_POLICY_INTERACTIVE = "interactive";
    public static final String DECISION_POLICY_PRELOAD = "preload";
    public static final String OPPORTUNITY_TYPE_PREROLL = "pre-roll";
    public static final String OPPORTUNITY_TYPE_POSTROLL = "post-roll";
    public static final String OPPORTUNITY_TYPE_INTERSTITIAL = "interstitial";
    public static final String OPPORTUNITY_TYPE_PAUSE = "pause";
    public static final String OPPORTUNITY_TYPE_FAST_FORWARD = "fast-forward";
    public static final String OPPORTUNITY_TYPE_REWIND = "rewind";
    public static final String OPPORTUNITY_TYPE_SESSION_START = "session-start";
    public static final String OPPORTUNITY_TYPE_SESSION_END = "session-end";

    public Service(Element element) throws Exception {
        this.id = element.getAttribute(ATTR_ID);
        this.decisionPolicy = element.getAttribute(ATTR_DECISION_POLICY);
        this.opportunityType = element.getAttribute(ATTR_OPPORTUNITY_TYPE);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof ContentProvider) {
                this.provider = (ContentProvider)obj;
            }
            if (obj instanceof ProductType) {
                this.productType = (ProductType)obj;
            }
            if (obj instanceof Scope) {
                this.scope = (Scope)obj;
            }
            if (obj instanceof Program) {
                this.program = (Program)obj;
            }
            if (obj instanceof AdType) {
                this.adType = (AdType)obj;
            }
            if (obj instanceof Scope) {
                this.scope = (Scope)obj;
            }
            if (obj instanceof Ext) {
                this.ext = (Ext)obj;
            }
            if (!(obj instanceof PlacementDecisionOwner)) continue;
            this.owner = (PlacementDecisionOwner)obj;
        }
    }

    public Service() {
    }

    public Service(String id, String decisionPolicy, String opportunityType, Program program, AdType adType, ContentProvider provider, ProductType productType, PlacementDecisionOwner owner, Scope scope, Ext ext) {
        this.id = id;
        this.decisionPolicy = decisionPolicy;
        this.opportunityType = opportunityType;
        this.program = program;
        this.adType = adType;
        this.provider = provider;
        this.productType = productType;
        this.owner = owner;
        this.scope = scope;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        Service other = (Service)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getId(), other.getId())) {
            dUtils.devLog("Service equality check failed. Ids don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getDecisionPolicy(), other.getDecisionPolicy())) {
            dUtils.devLog("Service equality check failed. Decision Policies don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getOpportunityType(), other.getOpportunityType())) {
            dUtils.devLog("Service equality check failed. OpportunityTypes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getProvider(), other.getProvider())) {
            dUtils.devLog("Service equality check failed. ContentProviders don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getProductType(), other.getProductType())) {
            dUtils.devLog("Service equality check failed. ProductTypes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getScope(), other.getScope())) {
            dUtils.devLog("Service equality check failed. Scopes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getProgram(), other.getProgram())) {
            dUtils.devLog("Service equality check failed. Program don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getAdType(), other.getAdType())) {
            dUtils.devLog("Service equality check failed. AdTypes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getOwner(), other.getOwner())) {
            dUtils.devLog("Service equality check failed. Owners don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Service equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement service = factory.createElement(ELE_SERVICE, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(service, "adm");
        SCTE130Utils.setAttribute(service, ATTR_ID, this.getId());
        SCTE130Utils.setAttribute(service, ATTR_DECISION_POLICY, this.getDecisionPolicy());
        SCTE130Utils.setAttribute(service, ATTR_OPPORTUNITY_TYPE, this.getOpportunityType());
        SCTE130Utils.addOtherAttributes(service, this.anyAttributes);
        SCTE130Utils.addChildElement(service, this.getProgram());
        SCTE130Utils.addChildElement(service, this.getAdType());
        SCTE130Utils.addChildElement(service, this.getProvider());
        SCTE130Utils.addChildElement(service, this.getProductType());
        SCTE130Utils.addChildElement(service, this.getOwner());
        SCTE130Utils.addChildElement(service, this.getScope());
        SCTE130Utils.addChildElement(service, this.getExt());
        return service;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getDecisionPolicy() {
        return this.decisionPolicy;
    }

    public void setDecisionPolicy(String decisionPolicy) {
        this.decisionPolicy = decisionPolicy;
    }

    public String getOpportunityType() {
        return this.opportunityType;
    }

    public void setOpportunityType(String opportunityType) {
        this.opportunityType = opportunityType;
    }

    public AdType getAdType() {
        return this.adType;
    }

    public void setAdType(AdType adType) {
        this.adType = adType;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PlacementDecisionOwner getOwner() {
        return this.owner;
    }

    public void setOwner(PlacementDecisionOwner owner) {
        this.owner = owner;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public void setProductType(ProductType productType) {
        this.productType = productType;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public ContentProvider getProvider() {
        return this.provider;
    }

    public void setProvider(ContentProvider provider) {
        this.provider = provider;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }
}

