/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.SpotNPT;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.Tracking;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Spot
implements MessageInterface {
    private Tracking tracking = null;
    private Content content = null;
    private SpotNPT npt = null;
    private Ext ext = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private String[] namedAttributes = new String[0];
    public static final String ELE_SPOT = "Spot";

    public Spot(Element element) throws Exception {
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Tracking) {
                this.tracking = (Tracking)obj;
            }
            if (obj instanceof Content) {
                this.content = (Content)obj;
            }
            if (obj instanceof SpotNPT) {
                this.npt = (SpotNPT)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public Spot() {
    }

    public Spot(Tracking tracking, Content content, SpotNPT npt, Ext ext) {
        this.tracking = tracking;
        this.content = content;
        this.npt = npt;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        Spot other = (Spot)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.objectsEqual(this.getTracking(), other.getTracking())) {
            dUtils.devLog("Spot equality check failed. Tracking don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getContent(), other.getContent())) {
            dUtils.devLog("Spot equality check failed. Contents don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSpotNPT(), other.getSpotNPT())) {
            dUtils.devLog("Spot equality check failed. SpotNPTs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Spot equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement content = factory.createElement(ELE_SPOT, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(content, "adm");
        SCTE130Utils.addOtherAttributes(content, this.anyAttributes);
        SCTE130Utils.addChildElement(content, this.getTracking());
        SCTE130Utils.addChildElement(content, this.getContent());
        SCTE130Utils.addChildElement(content, this.getSpotNPT());
        SCTE130Utils.addChildElement(content, this.getExt());
        return content;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Tracking getTracking() {
        return this.tracking;
    }

    public void setTracking(Tracking tracking) {
        this.tracking = tracking;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public Content getContent() {
        return this.content;
    }

    public SpotNPT getSpotNPT() {
        return this.npt;
    }

    public void setNPT(SpotNPT npt) {
        this.npt = npt;
    }

    public void setContent(Content content) {
        this.content = content;
    }
}

