/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.adm;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.adm.Events;
import com.ttv.SCTE130.messages.adm.Spot;
import com.ttv.SCTE130.utils.DateUtils;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.Date;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpotScopedEvents
implements MessageInterface {
    private Date eventRangeStartDateTime = null;
    private Date eventRangeEndDateTime = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private Spot spot = null;
    private Events events = null;
    public static final String ELE_SPOT_SCOPED_EVENTS = "SpotScopedEvents";
    private static final String ATTR_EVENT_RANGE_START = "eventRangeStartDateTime";
    private static final String ATTR_EVENT_RANGE_END = "eventRangeEndDateTime";
    private String[] namedAttributes = new String[]{"eventRangeStartDateTime", "eventRangeEndDateTime"};

    public SpotScopedEvents(Element element) throws Exception {
        String remoteEventRangeStart = element.getAttribute(ATTR_EVENT_RANGE_START);
        String remoteEventRangeEnd = element.getAttribute(ATTR_EVENT_RANGE_END);
        if (remoteEventRangeStart != null && remoteEventRangeStart.length() > 0) {
            try {
                this.eventRangeStartDateTime = DateUtils.parseXSDDateTime(remoteEventRangeStart);
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to parse StartTime in SpotScopedEvents.");
            }
        }
        if (remoteEventRangeEnd != null && remoteEventRangeEnd.length() > 0) {
            try {
                this.eventRangeEndDateTime = DateUtils.parseXSDDateTime(remoteEventRangeEnd);
            }
            catch (Exception e) {
                SCTE130Utils.getInstance().devLog("Failed to parse EndTime in SpotScopedEvents.");
            }
        }
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Spot) {
                this.spot = (Spot)obj;
            }
            if (!(obj instanceof Events)) continue;
            this.events = (Events)obj;
        }
    }

    public SpotScopedEvents() {
    }

    public SpotScopedEvents(Date eventRangeStartDateTime, Date eventRangeEndDateTime, Spot spot, Events events) {
        this.eventRangeStartDateTime = eventRangeStartDateTime;
        this.eventRangeEndDateTime = eventRangeEndDateTime;
        this.spot = spot;
        this.events = events;
    }

    public boolean equals(MessageInterface obj) {
        SpotScopedEvents other = (SpotScopedEvents)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getEventRangeStartDateTime().compareTo(other.getEventRangeStartDateTime()) != 0) {
            dUtils.devLog("SpotScopedEvents equality check failed. EventRange StartTimes don't match.");
            return false;
        }
        if (this.getEventRangeEndDateTime().compareTo(other.getEventRangeEndDateTime()) != 0) {
            dUtils.devLog("SpotScopedEvents equality check failed. EventRange EndTimes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getSpot(), other.getSpot())) {
            dUtils.devLog("SpotScopedEvents equality check failed. Spots don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getEvents(), other.getEvents())) {
            dUtils.devLog("SpotScopedEvents equality check failed. Events don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement spotScope = factory.createElement(ELE_SPOT_SCOPED_EVENTS, "adm", nameSpaces.getURIForName("adm"));
        nameSpaces.populateNamespace(spotScope, "adm");
        SCTE130Utils.setAttribute(spotScope, ATTR_EVENT_RANGE_START, this.getEventRangeStartDateTimeAsStr());
        SCTE130Utils.setAttribute(spotScope, ATTR_EVENT_RANGE_END, this.getEventRangeEndDateTimeAsStr());
        SCTE130Utils.addOtherAttributes(spotScope, this.anyAttributes);
        SCTE130Utils.addChildElement(spotScope, this.getSpot());
        SCTE130Utils.addChildElement(spotScope, this.getEvents());
        return spotScope;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Date getEventRangeEndDateTime() {
        return this.eventRangeEndDateTime;
    }

    public String getEventRangeEndDateTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.eventRangeEndDateTime);
    }

    public void setEventRangeEndDateTime(Date eventRangeEndDateTime) {
        this.eventRangeEndDateTime = eventRangeEndDateTime;
    }

    public Date getEventRangeStartDateTime() {
        return this.eventRangeStartDateTime;
    }

    public String getEventRangeStartDateTimeAsStr() {
        return DateUtils.formatXSDDateTime(this.eventRangeStartDateTime);
    }

    public void setEventRangeStartDateTime(Date eventRangeStartDateTime) {
        this.eventRangeStartDateTime = eventRangeStartDateTime;
    }

    public Events getEvents() {
        return this.events;
    }

    public void setEvents(Events events) {
        this.events = events;
    }

    public Spot getSpot() {
        return this.spot;
    }

    public void setSpot(Spot spot) {
        this.spot = spot;
    }
}

