/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.cis.ContentQueryResult;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentNotification
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String resend = null;
    private String type = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private ContentQueryResult contentQueryResult = null;
    private Ext ext = null;
    public static final String ELE_CONTENT_NOTIFICATION = "ContentNotification";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_IDENTITY = "identity";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_RESEND = "resend";
    private static final String ATTR_TYPE = "type";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "resend", "type"};
    public static final String New = "new";
    public static final String Update = "update";
    public static final String Delete = "delete";

    public ContentNotification(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.type = element.getAttribute(ATTR_TYPE);
        this.resend = element.getAttribute(ATTR_RESEND);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof InitiatorData) {
                this.initData = (InitiatorData)obj;
            }
            if (obj instanceof ContentQueryResult) {
                this.contentQueryResult = (ContentQueryResult)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public ContentNotification() {
    }

    public ContentNotification(String messageId, String identity, String system, String type, ContentQueryResult contentQueryResult, Ext ext) {
        this.messageId = messageId;
        this.identity = identity;
        this.system = system;
        this.type = type;
        this.contentQueryResult = contentQueryResult;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        ContentNotification other = (ContentNotification)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("ContentNotification equality check failed. MessageIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("ContentNotification equality check failed. Identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("ContentNotification equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getResend(), other.getResend())) {
            dUtils.devLog("ContentNotification equality check failed. Resends don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getType(), other.getType())) {
            dUtils.devLog("ContentNotification equality check failed. Types don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("ContentNotification equality check failed. InitiatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getContentQueryResult(), other.getContentQueryResult())) {
            dUtils.devLog("ContentNotification equality check failed. QueryResults don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("ContentNotification equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement contentNotification = factory.createElement(ELE_CONTENT_NOTIFICATION, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(contentNotification, "cis");
        SCTE130Utils.setAttribute(contentNotification, ATTR_MESSAGE_ID, this.getMessageId());
        SCTE130Utils.setAttribute(contentNotification, ATTR_VERSION, this.getVersion());
        SCTE130Utils.setAttribute(contentNotification, ATTR_IDENTITY, this.getIdentity());
        SCTE130Utils.setAttribute(contentNotification, ATTR_SYSTEM, this.getSystem());
        SCTE130Utils.setAttribute(contentNotification, ATTR_RESEND, this.getResend());
        SCTE130Utils.setAttribute(contentNotification, ATTR_TYPE, this.getType());
        SCTE130Utils.addOtherAttributes(contentNotification, this.anyAttributes);
        SCTE130Utils.addChildElement(contentNotification, this.getInitData());
        SCTE130Utils.addChildElement(contentNotification, this.getContentQueryResult());
        SCTE130Utils.addChildElement(contentNotification, this.getExt());
        return contentNotification;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getResend() {
        return this.resend;
    }

    public void setResend(String resend) {
        this.resend = resend;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public ContentQueryResult getContentQueryResult() {
        return this.contentQueryResult;
    }

    public String getSystem() {
        return this.system;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getType() {
        return this.type;
    }

    public void setContentQueryResult(ContentQueryResult contentQueryResult) {
        this.contentQueryResult = contentQueryResult;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setType(String type) {
        this.type = type;
    }
}

