/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.cis.QueryFilter;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNotificationSelector
implements MessageInterface {
    private String queryId = null;
    private boolean expandOutput = false;
    private ContentDataModel dataModel = null;
    private List<QueryFilter> queryFilters = null;
    public static final String ELE_CONTENT_NOTIFICATION_SELECTOR = "ContentNotificationSelector";
    private static final String ATTR_QUERY_ID = "queryId";
    private static final String ATTR_EXPAND_OUTPUT = "expandOutput";

    public ContentNotificationSelector(Element element) throws Exception {
        this.queryId = element.getAttribute(ATTR_QUERY_ID);
        String remoteExpandOutput = element.getAttribute(ATTR_EXPAND_OUTPUT);
        if (remoteExpandOutput != null && remoteExpandOutput.length() > 0) {
            this.expandOutput = Boolean.parseBoolean(remoteExpandOutput);
        }
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof ContentDataModel) {
                this.dataModel = (ContentDataModel)obj;
            }
            if (!(obj instanceof QueryFilter)) continue;
            if (this.queryFilters == null) {
                this.queryFilters = new ArrayList<QueryFilter>();
            }
            this.queryFilters.add((QueryFilter)obj);
        }
    }

    public ContentNotificationSelector() {
    }

    public ContentNotificationSelector(ContentDataModel dataModel, String queryId, boolean expandOutput, List<QueryFilter> queryFilters) {
        this.dataModel = dataModel;
        this.queryId = queryId;
        this.expandOutput = expandOutput;
        this.queryFilters = queryFilters;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        ContentNotificationSelector other = (ContentNotificationSelector)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getQueryId(), other.getQueryId())) {
            dUtils.devLog("ContentNotificationSelector equality check failed. QueryIds don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getDataModel(), other.getDataModel())) {
            dUtils.devLog("ContentNotificationSelector equality check failed. DataModels don't match.");
            return false;
        }
        if (this.getExpandOutput() != other.getExpandOutput()) {
            dUtils.devLog("ContentNotificationSelector equality check failed. ExpandOutput flags don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getQueryFilters(), other.getQueryFilters())) {
            dUtils.devLog("ContentNotificationSelector equality check failed. QueryFilter Lists don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement contentSelector = factory.createElement(ELE_CONTENT_NOTIFICATION_SELECTOR, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(contentSelector, "cis");
        contentSelector.setAttribute(ATTR_QUERY_ID, this.getQueryId());
        contentSelector.setAttribute(ATTR_EXPAND_OUTPUT, this.getStrExpandOutput());
        SCTE130Utils.addChildElement(contentSelector, this.getDataModel());
        SCTE130Utils.addChildElementList(contentSelector, this.getQueryFilters());
        return contentSelector;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public ContentDataModel getDataModel() {
        return this.dataModel;
    }

    public boolean getExpandOutput() {
        return this.expandOutput;
    }

    public String getStrExpandOutput() {
        return this.expandOutput ? "true" : "false";
    }

    public List<QueryFilter> getQueryFilters() {
        return this.queryFilters;
    }

    public void setQueryFilters(List<QueryFilter> queryFilters) {
        this.queryFilters = queryFilters;
    }

    public void setDataModel(ContentDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void setExpandOutput(boolean expandOutput) {
        this.expandOutput = expandOutput;
    }
}

