/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.cis.ContentQueryResult;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentQueryResponse
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String messageRef = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private ContentQueryResult queryResult = null;
    private StatusCode statusCode = null;
    private Ext ext = null;
    public static final String ELE_CONTENT_QUERY_RESPONSE = "ContentQueryResponse";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_IDENTITY = "identity";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_MESSAGE_REF = "messageRef";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "messageRef"};

    public ContentQueryResponse(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.messageRef = element.getAttribute(ATTR_MESSAGE_REF);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof InitiatorData) {
                this.initData = (InitiatorData)obj;
            }
            if (obj instanceof StatusCode) {
                this.statusCode = (StatusCode)obj;
            }
            if (obj instanceof ContentQueryResult) {
                this.queryResult = (ContentQueryResult)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public ContentQueryResponse() {
    }

    public ContentQueryResponse(String messageId, String identity, String system, String messageRef, StatusCode statusCode, ContentQueryResult queryResult, Ext ext) {
        this.messageId = messageId;
        this.identity = identity;
        this.system = system;
        this.statusCode = statusCode;
        this.messageRef = messageRef;
        this.queryResult = queryResult;
        this.ext = ext;
    }

    public boolean equals(MessageInterface obj) {
        ContentQueryResponse other = (ContentQueryResponse)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("ContentQueryResponse equality check failed. MessageIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("ContentQueryResponse equality check failed. Identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("ContentQueryResponse equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getMessageRef(), other.getMessageRef())) {
            dUtils.devLog("ContentQueryResponse equality check failed. MessageRefs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("ContentQueryResponse equality check failed. InitiatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getStatusCode(), other.getStatusCode())) {
            dUtils.devLog("ContentQueryResponse equality check failed. StatusCodes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getQueryResult(), other.getQueryResult())) {
            dUtils.devLog("ContentQueryResponse equality check failed. Query Results don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("ContentQueryResponse equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement queryResponse = factory.createElement(ELE_CONTENT_QUERY_RESPONSE, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(queryResponse, "cis");
        queryResponse.setAttribute(ATTR_MESSAGE_ID, this.getMessageId());
        queryResponse.setAttribute(ATTR_VERSION, this.getVersion());
        queryResponse.setAttribute(ATTR_IDENTITY, this.getIdentity());
        queryResponse.setAttribute(ATTR_SYSTEM, this.getSystem());
        queryResponse.setAttribute(ATTR_MESSAGE_REF, this.getMessageRef());
        SCTE130Utils.addOtherAttributes(queryResponse, this.anyAttributes);
        SCTE130Utils.addChildElement(queryResponse, this.getInitData());
        SCTE130Utils.addChildElement(queryResponse, this.getStatusCode());
        SCTE130Utils.addChildElement(queryResponse, this.getQueryResult());
        SCTE130Utils.addChildElement(queryResponse, this.getExt());
        return queryResponse;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageRef() {
        return this.messageRef;
    }

    public void setMessageRef(String messageRef) {
        this.messageRef = messageRef;
    }

    public ContentQueryResult getQueryResult() {
        return this.queryResult;
    }

    public void setQueryResult(ContentQueryResult queryResult) {
        this.queryResult = queryResult;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

