/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

public class FilterElement
implements MessageInterface {
    private String name = null;
    private String value = null;
    private boolean valueIsRegex = false;
    public static final String ELE_FILTER_ELEMENT = "FilterElement";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_VALUE_IS_REGEX = "valueIsRegex";

    public FilterElement(Element element) throws Exception {
        this.name = element.getAttribute(ATTR_NAME);
        this.value = element.getAttribute(ATTR_VALUE);
        String remoteValueIsRegex = element.getAttribute(ATTR_VALUE_IS_REGEX);
        if (remoteValueIsRegex != null && remoteValueIsRegex.length() > 0) {
            this.valueIsRegex = Boolean.parseBoolean(remoteValueIsRegex);
        }
    }

    public FilterElement() {
    }

    public FilterElement(String name, String value, boolean valueIsRegex) {
        this.name = name;
        this.value = value;
        this.valueIsRegex = valueIsRegex;
    }

    public boolean equals(MessageInterface obj) {
        FilterElement other = (FilterElement)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getName(), other.getName())) {
            dUtils.devLog("FilterElement equality check failed. Names don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getValue(), other.getValue())) {
            dUtils.devLog("FilterElement equality check failed. Values don't match.");
            return false;
        }
        if (this.isValueIsRegex() != other.isValueIsRegex()) {
            dUtils.devLog("FilterElement equality check failed. ValueIsRegex flags don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement filterElement = factory.createElement(ELE_FILTER_ELEMENT, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(filterElement, "cis");
        filterElement.setAttribute(ATTR_NAME, this.getName());
        filterElement.setAttribute(ATTR_VALUE, this.getValue());
        filterElement.setAttribute(ATTR_VALUE_IS_REGEX, Boolean.toString(this.isValueIsRegex()));
        return filterElement;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isValueIsRegex() {
        return this.valueIsRegex;
    }

    public void setValueIsRegex(boolean valueIsRegex) {
        this.valueIsRegex = valueIsRegex;
    }
}

