/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.cis;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.TopLevelMessage;
import com.ttv.SCTE130.messages.cis.ContentNotificationRegistrationRequest;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.InitiatorData;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListContentNotificationRegistrationResponse
implements MessageInterface,
TopLevelMessage {
    private String messageId = null;
    private String version = "1.0";
    private String identity = null;
    private String system = null;
    private String messageRef = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private InitiatorData initData = null;
    private StatusCode statusCode = null;
    private List<ContentNotificationRegistrationRequest> registrationItems = null;
    private Ext ext = null;
    public static final String ELE_LIST_CONTENT_NOTIFICATION_REGISTRATION_RESPONSE = "ListContentNotificationRegistrationResponse";
    private static final String ATTR_MESSAGE_ID = "messageId";
    private static final String ATTR_IDENTITY = "identity";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_SYSTEM = "system";
    private static final String ATTR_MESSAGE_REF = "messageRef";
    private String[] namedAttributes = new String[]{"messageId", "version", "identity", "system", "messageRef"};

    public ListContentNotificationRegistrationResponse(Element element) throws Exception {
        this.messageId = element.getAttribute(ATTR_MESSAGE_ID);
        this.identity = element.getAttribute(ATTR_IDENTITY);
        this.system = element.getAttribute(ATTR_SYSTEM);
        this.messageRef = element.getAttribute(ATTR_MESSAGE_REF);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof InitiatorData) {
                this.initData = (InitiatorData)obj;
            }
            if (obj instanceof StatusCode) {
                this.statusCode = (StatusCode)obj;
            }
            if (!(obj instanceof ContentNotificationRegistrationRequest)) continue;
            if (this.registrationItems == null) {
                this.registrationItems = new ArrayList<ContentNotificationRegistrationRequest>();
            }
            this.registrationItems.add((ContentNotificationRegistrationRequest)obj);
        }
    }

    public ListContentNotificationRegistrationResponse() {
    }

    public ListContentNotificationRegistrationResponse(String messageId, String identity, String system, String messageRef, StatusCode statusCode, List<ContentNotificationRegistrationRequest> registrationItems, Ext ext) {
        this.messageId = messageId;
        this.identity = identity;
        this.system = system;
        this.statusCode = statusCode;
        this.messageRef = messageRef;
        this.registrationItems = registrationItems;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        ListContentNotificationRegistrationResponse other = (ListContentNotificationRegistrationResponse)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessageId(), other.getMessageId())) {
            dUtils.devLog("ListContentNotificationRegistrationResponse equality check failed. MessageIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getIdentity(), other.getIdentity())) {
            dUtils.devLog("ListContentNotificationRegistrationResponse equality check failed. Identities don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSystem(), other.getSystem())) {
            dUtils.devLog("ListContentNotificationRegistrationResponse equality check failed. Systems don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getMessageRef(), other.getMessageRef())) {
            dUtils.devLog("ListContentNotificationRegistrationResponse equality check failed. MessageRefs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getInitData(), other.getInitData())) {
            dUtils.devLog("ListContentNotificationRegistrationResponse equality check failed. InitiatorData don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getStatusCode(), other.getStatusCode())) {
            dUtils.devLog("ListContentNotificationRegistrationResponse equality check failed. StatusCodes don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getRegistrationItems(), other.getRegistrationItems())) {
            dUtils.devLog("ListContentNotificationRegistrationResponse equality check failed. Registration Items don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("ListContentNotificationRegistrationResponse equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement registrationResponse = factory.createElement(ELE_LIST_CONTENT_NOTIFICATION_REGISTRATION_RESPONSE, "cis", nameSpaces.getURIForName("cis"));
        nameSpaces.populateNamespace(registrationResponse, "cis");
        SCTE130Utils.setAttribute(registrationResponse, ATTR_MESSAGE_ID, this.getMessageId());
        SCTE130Utils.setAttribute(registrationResponse, ATTR_VERSION, this.getVersion());
        SCTE130Utils.setAttribute(registrationResponse, ATTR_IDENTITY, this.getIdentity());
        SCTE130Utils.setAttribute(registrationResponse, ATTR_SYSTEM, this.getSystem());
        SCTE130Utils.setAttribute(registrationResponse, ATTR_MESSAGE_REF, this.getMessageRef());
        SCTE130Utils.addOtherAttributes(registrationResponse, this.anyAttributes);
        SCTE130Utils.addChildElement(registrationResponse, this.getInitData());
        SCTE130Utils.addChildElement(registrationResponse, this.getStatusCode());
        SCTE130Utils.addChildElementList(registrationResponse, this.getRegistrationItems());
        SCTE130Utils.addChildElement(registrationResponse, this.getExt());
        return registrationResponse;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    @Override
    public InitiatorData getInitData() {
        return this.initData;
    }

    public void setInitData(InitiatorData initData) {
        this.initData = initData;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public List<ContentNotificationRegistrationRequest> getRegistrationItems() {
        return this.registrationItems;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getMessageRef() {
        return this.messageRef;
    }

    public String getSystem() {
        return this.system;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setMessageRef(String messageRef) {
        this.messageRef = messageRef;
    }

    public void setRegistrationItems(List<ContentNotificationRegistrationRequest> registrationItems) {
        this.registrationItems = registrationItems;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public void setSystem(String system) {
        this.system = system;
    }
}

