/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

public class AssetRef
implements MessageInterface {
    private String assetId = null;
    private String providerId = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_ASSET_REF = "AssetRef";
    private static final String ATTR_ASSET_ID = "assetID";
    private static final String ATTR_PROVIDER_ID = "providerID";
    private String[] namedAttributes = new String[]{"assetID", "providerID"};

    public AssetRef(Element element) throws Exception {
        this.assetId = element.getAttribute(ATTR_ASSET_ID);
        this.providerId = element.getAttribute(ATTR_PROVIDER_ID);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
    }

    public AssetRef() {
    }

    public AssetRef(String assetId, String providerId) {
        this.assetId = assetId;
        this.providerId = providerId;
    }

    public boolean equals(Object other) {
        if (other instanceof MessageInterface) {
            return this.equals((MessageInterface)other);
        }
        AssetRef assetRef = (AssetRef)other;
        return assetRef.getAssetId().equals(this.getAssetId()) && assetRef.getProviderId().equals(this.getProviderId());
    }

    public boolean equals(MessageInterface obj) {
        AssetRef other = (AssetRef)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getAssetId(), other.getAssetId())) {
            dUtils.devLog("AssetRef equality check failed. AssetIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getProviderId(), other.getProviderId())) {
            dUtils.devLog("AssetRef equality check failed. ProviderId flags don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement assetRef = factory.createElement(ELE_ASSET_REF, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(assetRef, "core");
        SCTE130Utils.setAttribute(assetRef, ATTR_PROVIDER_ID, this.getProviderId());
        SCTE130Utils.setAttribute(assetRef, ATTR_ASSET_ID, this.getAssetId());
        SCTE130Utils.addOtherAttributes(assetRef, this.anyAttributes);
        return assetRef;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }
}

