/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.Address;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Callout
implements MessageInterface {
    private String message = null;
    private List<Address> addresses = null;
    private Ext ext = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_CALLOUTS = "Callout";
    private static final String ATTR_MESSAGE = "message";
    private String[] namedAttributes = new String[]{"message"};

    public Callout(Element element) throws Exception {
        this.message = element.getAttribute(ATTR_MESSAGE);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof Address) {
                if (this.addresses == null) {
                    this.addresses = new ArrayList<Address>();
                }
                this.addresses.add((Address)obj);
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public Callout() {
    }

    public Callout(String message, List<Address> addresses, Ext ext) {
        this.message = message;
        this.addresses = addresses;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        Callout other = (Callout)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getMessage(), other.getMessage())) {
            dUtils.devLog("Callout equality check failed. Messages don't match");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getAddresses(), other.getAddresses())) {
            dUtils.devLog("Callout equality check failed. Addresses don't match");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(this.getExt(), other.getExt())) {
            dUtils.devLog("Callout equality check failed. Exts don't match");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement callout = factory.createElement(ELE_CALLOUTS, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(callout, "core");
        SCTE130Utils.setAttribute(callout, ATTR_MESSAGE, this.getMessage());
        SCTE130Utils.addOtherAttributes(callout, this.anyAttributes);
        SCTE130Utils.addChildElementList(callout, this.getAddresses());
        SCTE130Utils.addChildElement(callout, this.getExt());
        return callout;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }
}

