/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.AssetRef;
import com.ttv.SCTE130.messages.core.ContentLocation;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Ext;
import com.ttv.SCTE130.messages.core.Program;
import com.ttv.SCTE130.messages.core.SegmentationUpid;
import com.ttv.SCTE130.messages.core.SpotRef;
import com.ttv.SCTE130.messages.core.Tracking;
import com.ttv.SCTE130.messages.core.URI;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
implements MessageInterface {
    private String id = null;
    private AssetRef assetRef = null;
    private Program program = null;
    private SpotRef spotRef = null;
    private URI uri = null;
    private ContentLocation location = null;
    private AdType adType = null;
    private Duration duration = null;
    private Tracking tracking = null;
    private Ext ext = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private List<SegmentationUpid> upids = null;
    public static final String ELE_CONTENT = "Content";
    private static final String ATTR_ID = "id";
    private String[] namedAttributes = new String[]{"id"};

    public Content(Element element) throws Exception {
        this.id = element.getAttribute(ATTR_ID);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Node node = list.item(indx);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(child);
            Object obj = factory.allocateSCTE130Message(child);
            if (obj instanceof AssetRef) {
                this.assetRef = (AssetRef)obj;
            }
            if (obj instanceof Program) {
                this.program = (Program)obj;
            }
            if (obj instanceof SegmentationUpid) {
                if (this.upids == null) {
                    this.upids = new ArrayList<SegmentationUpid>();
                }
                this.upids.add((SegmentationUpid)obj);
            }
            if (obj instanceof SpotRef) {
                this.spotRef = (SpotRef)obj;
            }
            if (obj instanceof ContentLocation) {
                this.location = (ContentLocation)obj;
            }
            if (obj instanceof AdType) {
                this.adType = (AdType)obj;
            }
            if (obj instanceof Duration) {
                this.duration = (Duration)obj;
            }
            if (obj instanceof Tracking) {
                this.tracking = (Tracking)obj;
            }
            if (!(obj instanceof Ext)) continue;
            this.ext = (Ext)obj;
        }
    }

    public Content() {
    }

    public Content(String id, AssetRef assetRef, Duration duration, AdType adType, ContentLocation location, Tracking tracking, Ext ext) {
        this.id = id;
        this.uri = null;
        this.assetRef = assetRef;
        this.program = null;
        this.upids = null;
        this.spotRef = null;
        this.location = location;
        this.adType = adType;
        this.duration = duration;
        this.tracking = tracking;
        this.ext = ext;
    }

    public Content(String id, Program program, Duration duration, ContentLocation location, Tracking tracking, Ext ext) {
        this.id = id;
        this.uri = null;
        this.assetRef = null;
        this.program = program;
        this.upids = null;
        this.spotRef = null;
        this.adType = null;
        this.location = location;
        this.duration = duration;
        this.tracking = tracking;
        this.ext = ext;
    }

    public Content(String id, List<SegmentationUpid> upids, Duration duration, ContentLocation location, Tracking tracking, Ext ext) {
        this.id = id;
        this.uri = null;
        this.assetRef = null;
        this.program = null;
        this.upids = upids;
        this.spotRef = null;
        this.adType = null;
        this.location = location;
        this.duration = duration;
        this.tracking = tracking;
        this.ext = ext;
    }

    public Content(String id, SpotRef spotRef, Duration duration, AdType adType, ContentLocation location, Tracking tracking, Ext ext) {
        this.id = id;
        this.uri = null;
        this.assetRef = null;
        this.program = null;
        this.upids = null;
        this.location = location;
        this.spotRef = spotRef;
        this.adType = adType;
        this.duration = duration;
        this.tracking = tracking;
        this.ext = ext;
    }

    public Content(String id, URI uri, Duration duration, ContentLocation location, Tracking tracking, Ext ext) {
        this.id = id;
        this.uri = uri;
        this.assetRef = null;
        this.program = null;
        this.upids = null;
        this.location = location;
        this.spotRef = null;
        this.adType = null;
        this.duration = duration;
        this.tracking = tracking;
        this.ext = ext;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        Content other = (Content)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(other.getId(), this.getId())) {
            dUtils.devLog("Content equality check failed. IDs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getLocation(), this.getLocation())) {
            dUtils.devLog("Content equality check failed. Locations don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getAssetRef(), this.getAssetRef())) {
            dUtils.devLog("Content equality check failed. AssetRefs don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getProgram(), this.getProgram())) {
            dUtils.devLog("Content equality check failed. Programs don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(other.getUpids(), this.getUpids())) {
            dUtils.devLog("Content equality check failed. Upids don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getSpotRef(), this.getSpotRef())) {
            dUtils.devLog("Content equality check failed. SpotRef don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getAdType(), this.getAdType())) {
            dUtils.devLog("Content equality check failed. AdTypes don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getDuration(), this.getDuration())) {
            dUtils.devLog("Content equality check failed. Durations don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getTracking(), this.getTracking())) {
            dUtils.devLog("Content equality check failed. Tracking don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getUri(), this.getUri())) {
            dUtils.devLog("Content equality check failed. Uris don't match.");
            return false;
        }
        if (!SCTE130Utils.objectsEqual(other.getExt(), this.getExt())) {
            dUtils.devLog("Content equality check failed. Exts don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement content = factory.createElement(ELE_CONTENT, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(content, "core");
        SCTE130Utils.setAttribute(content, ATTR_ID, this.getId());
        SCTE130Utils.addOtherAttributes(content, this.anyAttributes);
        SCTE130Utils.addChildElement(content, this.getAssetRef());
        SCTE130Utils.addChildElement(content, this.getProgram());
        SCTE130Utils.addChildElementList(content, this.getUpids());
        SCTE130Utils.addChildElement(content, this.getSpotRef());
        SCTE130Utils.addChildElement(content, this.getUri());
        SCTE130Utils.addChildElement(content, this.getLocation());
        SCTE130Utils.addChildElement(content, this.getAdType());
        SCTE130Utils.addChildElement(content, this.getDuration());
        SCTE130Utils.addChildElement(content, this.getTracking());
        SCTE130Utils.addChildElement(content, this.getExt());
        return content;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public ContentLocation getLocation() {
        return this.location;
    }

    public void setLocation(ContentLocation location) {
        this.location = location;
    }

    public AdType getAdType() {
        return this.adType;
    }

    public void setAdType(AdType adType) {
        this.adType = adType;
    }

    public AssetRef getAssetRef() {
        return this.assetRef;
    }

    public void setAssetRef(AssetRef assetRef) {
        this.assetRef = assetRef;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Ext getExt() {
        return this.ext;
    }

    public void setExt(Ext ext) {
        this.ext = ext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public SpotRef getSpotRef() {
        return this.spotRef;
    }

    public void setSpotRef(SpotRef spotRef) {
        this.spotRef = spotRef;
    }

    public Tracking getTracking() {
        return this.tracking;
    }

    public void setTracking(Tracking tracking) {
        this.tracking = tracking;
    }

    public List<SegmentationUpid> getUpids() {
        return this.upids;
    }

    public void setUpids(List<SegmentationUpid> upids) {
        this.upids = upids;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

