/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.Note;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalStatusCode
implements MessageInterface {
    private String source = null;
    private String detail = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    private List<Note> notes = null;
    public static final String ELE_EXTERNAL_STATUS_CODE = "ExternalStatusCode";
    private static final String ATTR_SOURCE = "source";
    private static final String ATTR_DETAIL = "detail";
    private String[] namedAttributes = new String[]{"source", "detail"};

    public ExternalStatusCode(Element element) throws Exception {
        this.source = element.getAttribute(ATTR_SOURCE);
        this.detail = element.getAttribute(ATTR_DETAIL);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
        NodeList list = element.getChildNodes();
        for (int indx = 0; indx < list.getLength(); ++indx) {
            Element child;
            SCTE130MessageFactory factory;
            Object obj;
            Node node = list.item(indx);
            if (!(node instanceof Element) || !((obj = (factory = SCTE130MessageFactoryLocator.getMessageFactory(child = (Element)node)).allocateSCTE130Message(child)) instanceof Note)) continue;
            if (this.notes == null) {
                this.notes = new ArrayList<Note>();
            }
            this.notes.add((Note)obj);
        }
    }

    public ExternalStatusCode() {
    }

    public ExternalStatusCode(String source, String detail, List<Note> notes) {
        this.source = source;
        this.detail = detail;
        this.notes = notes;
    }

    @Override
    public boolean equals(MessageInterface obj) {
        ExternalStatusCode other = (ExternalStatusCode)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (!SCTE130Utils.stringsEqual(this.getSource(), other.getSource())) {
            dUtils.devLog("ExternalStatusCode equality check failed. Sources don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getDetail(), other.getDetail())) {
            dUtils.devLog("ExternalStatusCode equality check failed. Details don't match.");
            return false;
        }
        if (!SCTE130Utils.listsEqual(this.getNotes(), other.getNotes())) {
            dUtils.devLog("ExternalStatusCode equality check failed. Notes don't match.");
            return false;
        }
        return true;
    }

    @Override
    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement extStatusCode = factory.createElement(ELE_EXTERNAL_STATUS_CODE, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(extStatusCode, "core");
        SCTE130Utils.setAttribute(extStatusCode, ATTR_SOURCE, this.getSource());
        SCTE130Utils.setAttribute(extStatusCode, ATTR_DETAIL, this.getDetail());
        SCTE130Utils.addOtherAttributes(extStatusCode, this.anyAttributes);
        SCTE130Utils.addChildElementList(extStatusCode, this.getNotes());
        return extStatusCode;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public List<Note> getNotes() {
        return this.notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

