/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.messages.core;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.SCTE130Utils;
import java.util.TreeMap;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;

public class SpotRef
implements MessageInterface {
    private int trafficId;
    private String spotId = null;
    private String advertiserName = null;
    private String spotName = null;
    private String spotType = null;
    private String schedSource = null;
    private String adId = null;
    private TreeMap<String, String> anyAttributes = new TreeMap();
    public static final String ELE_SPOT_REF = "SpotRef";
    private static final String ATTR_TRAFFIC_ID = "trafficId";
    private static final String ATTR_SPOT_ID = "spotId";
    private static final String ATTR_ADVERTISER_NAME = "advertiserName";
    private static final String ATTR_SPOT_NAME = "spotName";
    private static final String ATTR_SPOT_TYPE = "spotType";
    private static final String ATTR_SCHED_SOURCE = "schedSource";
    private static final String ATTR_AD_ID = "adId";
    private String[] namedAttributes = new String[]{"trafficId", "spotId", "advertiserName", "spotName", "spotType", "schedSource", "adId"};

    public SpotRef(Element element) throws Exception {
        String remoteTrafficId = element.getAttribute(ATTR_TRAFFIC_ID);
        if (remoteTrafficId != null && remoteTrafficId.length() > 0) {
            this.trafficId = Integer.parseInt(remoteTrafficId);
        }
        this.spotId = element.getAttribute(ATTR_SPOT_ID);
        this.advertiserName = element.getAttribute(ATTR_ADVERTISER_NAME);
        this.spotName = element.getAttribute(ATTR_SPOT_NAME);
        this.spotType = element.getAttribute(ATTR_SPOT_TYPE);
        this.schedSource = element.getAttribute(ATTR_SCHED_SOURCE);
        this.adId = element.getAttribute(ATTR_AD_ID);
        this.anyAttributes = SCTE130Utils.locateOtherAttributes(this.namedAttributes, element.getAttributes());
    }

    public SpotRef() {
    }

    public SpotRef(int trafficId, String spotId, String advertiserName, String spotName, String spotType, String schedSource, String adId) {
        this.trafficId = trafficId;
        this.spotId = spotId;
        this.advertiserName = advertiserName;
        this.spotName = spotName;
        this.spotType = spotType;
        this.schedSource = schedSource;
        this.adId = adId;
    }

    public boolean equals(MessageInterface obj) {
        SpotRef other = (SpotRef)obj;
        SCTE130Utils dUtils = SCTE130Utils.getInstance();
        if (this.getTrafficId() != other.getTrafficId()) {
            dUtils.devLog("SpotRef equality check failed. TrafficIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSpotId(), other.getSpotId())) {
            dUtils.devLog("SpotRef equality check failed. SpotIds don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getAdvertiserName(), other.getAdvertiserName())) {
            dUtils.devLog("SpotRef equality check failed. AdvertiserNames don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSpotName(), other.getSpotName())) {
            dUtils.devLog("SpotRef equality check failed. SpotNames don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSpotType(), other.getSpotType())) {
            dUtils.devLog("SpotRef equality check failed. SpotTypes don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getSchedSource(), other.getSchedSource())) {
            dUtils.devLog("SpotRef equality check failed. SchedSources don't match.");
            return false;
        }
        if (!SCTE130Utils.stringsEqual(this.getAdId(), other.getAdId())) {
            dUtils.devLog("SpotRef equality check failed. AdIds don't match.");
            return false;
        }
        return true;
    }

    public SOAPElement getSOAPElement() throws SOAPException {
        SCTE130Namespaces nameSpaces = SCTE130Namespaces.getInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement spotRef = factory.createElement(ELE_SPOT_REF, "core", nameSpaces.getURIForName("core"));
        nameSpaces.populateNamespace(spotRef, "core");
        SCTE130Utils.setAttribute(spotRef, ATTR_TRAFFIC_ID, this.getTrafficIdAsStr());
        SCTE130Utils.setAttribute(spotRef, ATTR_SPOT_ID, this.getSpotId());
        SCTE130Utils.setAttribute(spotRef, ATTR_ADVERTISER_NAME, this.getAdvertiserName());
        SCTE130Utils.setAttribute(spotRef, ATTR_SPOT_NAME, this.getSpotName());
        SCTE130Utils.setAttribute(spotRef, ATTR_SPOT_TYPE, this.getSpotType());
        SCTE130Utils.setAttribute(spotRef, ATTR_SCHED_SOURCE, this.getSchedSource());
        SCTE130Utils.setAttribute(spotRef, ATTR_AD_ID, this.getAdId());
        SCTE130Utils.addOtherAttributes(spotRef, this.anyAttributes);
        return spotRef;
    }

    public void addAnyAttribute(String attributeName, String attributeValue) {
        this.anyAttributes.put(attributeName, attributeValue);
    }

    public String getAdId() {
        return this.adId;
    }

    public void setAdId(String adId) {
        this.adId = adId;
    }

    public String getAdvertiserName() {
        return this.advertiserName;
    }

    public void setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
    }

    public String getSchedSource() {
        return this.schedSource;
    }

    public void setSchedSource(String schedSource) {
        this.schedSource = schedSource;
    }

    public String getSpotId() {
        return this.spotId;
    }

    public void setSpotId(String spotId) {
        this.spotId = spotId;
    }

    public String getSpotName() {
        return this.spotName;
    }

    public void setSpotName(String spotName) {
        this.spotName = spotName;
    }

    public String getSpotType() {
        return this.spotType;
    }

    public void setSpotType(String spotType) {
        this.spotType = spotType;
    }

    public int getTrafficId() {
        return this.trafficId;
    }

    public String getTrafficIdAsStr() {
        return "" + this.trafficId;
    }

    public void setTrafficId(int trafficId) {
        this.trafficId = trafficId;
    }
}

