/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.server;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.messages.adm.ADMCapabilities;
import com.ttv.SCTE130.messages.adm.ADSDeregisterRequest;
import com.ttv.SCTE130.messages.adm.ADSDeregisterResponse;
import com.ttv.SCTE130.messages.adm.ADSRegistrationRequest;
import com.ttv.SCTE130.messages.adm.ADSRegistrationResponse;
import com.ttv.SCTE130.messages.adm.ContentProvider;
import com.ttv.SCTE130.messages.adm.ListADMServicesRequest;
import com.ttv.SCTE130.messages.adm.ListADMServicesResponse;
import com.ttv.SCTE130.messages.adm.ListADSRegistrationRequest;
import com.ttv.SCTE130.messages.adm.ListADSRegistrationResponse;
import com.ttv.SCTE130.messages.adm.PlacementDecisionOwner;
import com.ttv.SCTE130.messages.adm.PlacementUpdateAcknowledgement;
import com.ttv.SCTE130.messages.adm.PlacementUpdateNotification;
import com.ttv.SCTE130.messages.adm.ProductType;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.ServiceDescription;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.Address;
import com.ttv.SCTE130.messages.core.Callout;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Note;
import com.ttv.SCTE130.messages.core.Program;
import com.ttv.SCTE130.messages.core.ServiceCheckRequest;
import com.ttv.SCTE130.messages.core.ServiceCheckResponse;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.utils.Serializer;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SCTE130MessageService {
    public void process(SOAPEnvelope req, SOAPEnvelope resp) throws SOAPException {
        try {
            Serializer ser = new Serializer(System.out);
            ser.serialize((Element)req);
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory((Element)req);
            Object obj = factory.allocateSCTE130Message((Element)req);
            if (obj instanceof ServiceCheckRequest) {
                ServiceCheckResponse response = this.handleServiceCheckRequest((ServiceCheckRequest)obj);
                resp.getBody().appendChild((Node)response.getSOAPElement());
                SCTE130Namespaces.getInstance().populateNamespace((SOAPElement)resp, "adm");
                return;
            }
            if (obj instanceof ListADMServicesRequest) {
                ListADMServicesResponse rr = this.handleListADMServicesRequest((ListADMServicesRequest)obj);
                resp.getBody().appendChild((Node)rr.getSOAPElement());
                SCTE130Namespaces.getInstance().populateNamespace((SOAPElement)resp, "adm");
                return;
            }
            if (obj instanceof ListADSRegistrationRequest) {
                ListADSRegistrationResponse rr = this.handleListADSRegistrationRequest((ListADSRegistrationRequest)obj);
                resp.getBody().appendChild((Node)rr.getSOAPElement());
                SCTE130Namespaces.getInstance().populateNamespace((SOAPElement)resp, "adm");
                return;
            }
            if (obj instanceof ADSDeregisterRequest) {
                ADSDeregisterResponse rr = this.handleADSDeregisterRequest((ADSDeregisterRequest)obj);
                resp.getBody().appendChild((Node)rr.getSOAPElement());
                SCTE130Namespaces.getInstance().populateNamespace((SOAPElement)resp, "adm");
                return;
            }
            if (obj instanceof ADSRegistrationRequest) {
                ADSRegistrationResponse rr = this.handleADSRegistrationRequest((ADSRegistrationRequest)obj);
                resp.getBody().appendChild((Node)rr.getSOAPElement());
                SCTE130Namespaces.getInstance().populateNamespace((SOAPElement)resp, "adm");
                return;
            }
            if (obj instanceof PlacementUpdateNotification) {
                PlacementUpdateAcknowledgement rr = this.handlePlacementUpdateNotification((PlacementUpdateNotification)obj);
                resp.getBody().appendChild((Node)rr.getSOAPElement());
                SCTE130Namespaces.getInstance().populateNamespace((SOAPElement)resp, "adm");
                return;
            }
            System.out.println("Object type: " + obj.getClass().getName() + " not found.");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SOAPException(e.getMessage());
        }
    }

    public PlacementUpdateAcknowledgement handlePlacementUpdateNotification(PlacementUpdateNotification note) throws SOAPException, Exception {
        ArrayList<Note> notes = new ArrayList<Note>();
        notes.add(new Note("Placement Update Worked."));
        StatusCode status = new StatusCode(0, 0, notes, null);
        return new PlacementUpdateAcknowledgement("id", "identity", "system", note.getMessageId(), status, null);
    }

    public ServiceCheckResponse handleServiceCheckRequest(ServiceCheckRequest request) throws SOAPException, Exception {
        ArrayList<Note> notes = new ArrayList<Note>();
        notes.add(new Note("Hello World."));
        StatusCode status = new StatusCode(0, 0, notes, null);
        ServiceCheckResponse response = new ServiceCheckResponse("id", "identity", "system", request.getMessageId(), status, null);
        return response;
    }

    public ADSDeregisterResponse handleADSDeregisterRequest(ADSDeregisterRequest rr) throws SOAPException, Exception {
        ArrayList<Note> notesList = new ArrayList<Note>();
        notesList.add(new Note("Hello World"));
        return new ADSDeregisterResponse("id", "identity", "system", rr.getMessageId(), new StatusCode(0, 0, notesList, null), null);
    }

    public ListADSRegistrationResponse handleListADSRegistrationRequest(ListADSRegistrationRequest rr) throws SOAPException, Exception {
        SystemContext systemContext = new SystemContext(null, null, null, null, null, null);
        ContentProvider provider = new ContentProvider("Indemand.com", new ContentDataModel("CLADI_1.1", "http://www.cablelabs.com/<date>/ADI1.1"));
        Scope scope = new Scope("Local");
        Program program = new Program(101, new CurrentDateTime(new Date()));
        ProductType productType = new ProductType("MOD");
        AdType adType = new AdType("PreBumper");
        PlacementDecisionOwner owner = new PlacementDecisionOwner("owner");
        ArrayList<Service> serviceList = new ArrayList<Service>();
        serviceList.add(new Service("Id", "interactive", "pre-roll", program, adType, provider, productType, owner, scope, null));
        ArrayList<ServiceDescription> serviceDescriptionList = new ArrayList<ServiceDescription>();
        serviceDescriptionList.add(new ServiceDescription(serviceList, systemContext, null));
        ArrayList<Address> addressList = new ArrayList<Address>();
        addressList.add(new Address("url", "type"));
        ArrayList<Callout> callouts = new ArrayList<Callout>();
        callouts.add(new Callout("PlacementRequest", addressList, null));
        ArrayList<ADSRegistrationRequest> adsRegistrationRequestList = new ArrayList<ADSRegistrationRequest>();
        adsRegistrationRequestList.add(new ADSRegistrationRequest("id", "system", "identity", serviceDescriptionList, callouts, null));
        ArrayList<Note> notesList = new ArrayList<Note>();
        notesList.add(new Note("Hello World"));
        return new ListADSRegistrationResponse("id", "identity", "system", rr.getMessageId(), new StatusCode(0, 0, notesList, null), adsRegistrationRequestList, null);
    }

    public ListADMServicesResponse handleListADMServicesRequest(ListADMServicesRequest rr) throws SOAPException, Exception {
        SystemContext systemContext = new SystemContext(null, null, null, null, null, null);
        ContentProvider provider = new ContentProvider("indemand.com", new ContentDataModel("CLADI_1.1", "http://www.cablelabs.com/<date>/ADI1.1"));
        Scope scope = new Scope("Local");
        Program program = new Program(101, new CurrentDateTime(new Date()));
        ProductType productType = new ProductType("MOD");
        AdType adType = new AdType("PreBumper");
        PlacementDecisionOwner owner = new PlacementDecisionOwner("owner");
        ArrayList<Service> serviceList = new ArrayList<Service>();
        serviceList.add(new Service("1", "preload", "pre-roll", program, adType, provider, productType, owner, scope, null));
        ArrayList<ServiceDescription> serviceDescriptionList = new ArrayList<ServiceDescription>();
        serviceDescriptionList.add(new ServiceDescription(serviceList, systemContext, null));
        ArrayList<Note> noteList = new ArrayList<Note>();
        noteList.add(new Note("Hello World"));
        ADMCapabilities capabilities = new ADMCapabilities(false, null);
        ArrayList<Address> addresses = new ArrayList<Address>();
        ArrayList<Callout> callouts = new ArrayList<Callout>();
        addresses.add(new Address("http://10.250.30.96:8080/axis/services/SCTE130MessageService", "SOAP"));
        callouts.add(new Callout("ADSRegistrationRequest", addresses, null));
        callouts.add(new Callout("ADSDeregisterRequest", addresses, null));
        callouts.add(new Callout("ListADSRegistrationRequest", addresses, null));
        callouts.add(new Callout("ServiceCheckRequest", addresses, null));
        callouts.add(new Callout("ServiceStatusNotification", addresses, null));
        callouts.add(new Callout("PlacementUpdateNotification", addresses, null));
        return new ListADMServicesResponse("id", "identity", "system", rr.getMessageId(), new StatusCode(0, 0, noteList, null), capabilities, serviceDescriptionList, callouts, null);
    }

    public ADSRegistrationResponse handleADSRegistrationRequest(ADSRegistrationRequest rr) throws SOAPException, Exception {
        ArrayList<Note> noteList = new ArrayList<Note>();
        noteList.add(new Note("Hello World"));
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.add(new Address("http://10.250.30.96:8080/axis/services/SCTE130MessageService", "SOAP"));
        ArrayList<Callout> callouts = new ArrayList<Callout>();
        callouts.add(new Callout("", addresses, null));
        return new ADSRegistrationResponse("id", "identity", "system", rr.getMessageId(), new StatusCode(0, 0, noteList, null), null, null);
    }
}

