/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.server;

import com.ttv.SCTE130.server.SCTE130MessageHandler;
import com.ttv.SCTE130.utils.SCTE130MessageHolder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SCTE130SocketServer {
    private final Logger log = Logger.getLogger(SCTE130SocketServer.class);
    private ServerSocket serverSocket = null;
    private SocketAcceptor socketAcceptor = null;
    private WorkAssigner workAssigner = null;
    private SCTE130MessageHandler messageHandler = null;
    private Thread socketAcceptorThread = null;
    private Thread workAssignerThread = null;
    private int port = 0;
    private Vector<ClientSocketListener> clients = null;
    private int threadPoolInitialSize = 0;
    private int threadPoolMaximumSize = 0;
    private ArrayList<MessageWorker> threadWaitPool = null;
    private ArrayList<MessageWorker> threadWorkPool = null;
    private ArrayList<ReadyWorkHolder> readyWorkQueue = null;

    public SCTE130SocketServer(int port, SCTE130MessageHandler messageHandler, int threadPoolInitialSize, int threadPoolMaximumSize) {
        this.port = port;
        this.clients = new Vector();
        this.messageHandler = messageHandler;
        this.threadPoolInitialSize = threadPoolInitialSize;
        this.threadPoolMaximumSize = threadPoolMaximumSize;
        this.allocateThreadPool();
    }

    public void start() throws IOException {
        this.serverSocket = new ServerSocket(this.port);
        this.socketAcceptor = new SocketAcceptor(this.serverSocket);
        this.workAssigner = new WorkAssigner();
        this.workAssignerThread = new Thread(this.workAssigner);
        this.workAssignerThread.start();
        this.socketAcceptorThread = new Thread(this.socketAcceptor);
        this.socketAcceptorThread.start();
        this.log.debug((Object)"SCTE130SocketServer started.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            int indx;
            for (indx = 0; indx < this.clients.size(); ++indx) {
                ClientSocketListener csl = this.clients.get(indx);
                csl.shutdown();
            }
            for (indx = 0; indx < this.threadWaitPool.size(); ++indx) {
                MessageWorker worker = this.threadWaitPool.get(indx);
                worker.shutdown();
                try {
                    worker.interrupt();
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            this.socketAcceptor.shutdown();
            try {
                this.socketAcceptorThread.interrupt();
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            this.workAssigner.shutdown();
            try {
                this.workAssignerThread.interrupt();
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failure during shutdown.", (Throwable)e);
        }
        finally {
            try {
                this.serverSocket.close();
                this.log.debug((Object)"Server side socket closed.");
            }
            catch (Exception exception) {}
        }
        this.log.debug((Object)"SCTE130SocketAcceptor stopped.");
    }

    private void manageSocket(Socket socket) throws IOException {
        Thread client = null;
        ClientSocketListenerRaw csl = new ClientSocketListenerRaw(socket);
        this.clients.add(csl);
        client = new Thread(csl);
        client.start();
        this.log.debug((Object)("New client connection from addr: " + socket.getInetAddress().getHostAddress() + ". There are " + this.getActiveClientCount() + " clients connected."));
    }

    private void removeClient(ClientSocketListener csl) {
        this.clients.remove(csl);
    }

    public int getActiveClientCount() {
        return this.clients.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageWorker allocateWorkerThread() {
        while (true) {
            ArrayList<MessageWorker> arrayList = this.threadWaitPool;
            synchronized (arrayList) {
                if (this.threadWaitPool.size() != 0) break block5;
                if (this.threadWorkPool.size() != this.threadPoolMaximumSize) break;
                this.log.warn((Object)"Thread pool maximum size reached. Work assigner waiting for worker thread pool resources.");
                try {
                    this.threadWaitPool.wait(250L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
        {
            block5: {
                this.threadWaitPool.add(new MessageWorker());
            }
            MessageWorker worker = this.threadWaitPool.remove(0);
            this.threadWorkPool.add(worker);
            return worker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnToPool(MessageWorker messageWorker) {
        ArrayList<MessageWorker> arrayList = this.threadWaitPool;
        synchronized (arrayList) {
            this.threadWorkPool.remove(messageWorker);
            this.threadWaitPool.add(messageWorker);
            this.threadWaitPool.notify();
        }
    }

    private void allocateThreadPool() {
        this.threadWaitPool = new ArrayList();
        this.threadWorkPool = new ArrayList();
        this.readyWorkQueue = new ArrayList();
        for (int indx = 0; indx < this.threadPoolInitialSize; ++indx) {
            this.threadWaitPool.add(new MessageWorker());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkToQueue(ReadyWorkHolder workHolder) {
        ArrayList<ReadyWorkHolder> arrayList = this.readyWorkQueue;
        synchronized (arrayList) {
            this.readyWorkQueue.add(0, workHolder);
            this.readyWorkQueue.notify();
        }
    }

    public class ClientSocketListenerRaw
    implements Runnable,
    ClientSocketListener {
        private Socket socket = null;
        private boolean stop = false;
        private DataInputStream inputStream = null;
        private DataOutputStream outputStream = null;

        public ClientSocketListenerRaw(Socket socket) throws IOException {
            this.socket = socket;
            this.inputStream = new DataInputStream(this.socket.getInputStream());
            this.outputStream = new DataOutputStream(this.socket.getOutputStream());
            SCTE130SocketServer.this.log.debug((Object)"Installing RAW client socket listener.");
        }

        public void shutdown() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transmitMessage(SCTE130MessageHolder messageHolder) throws IOException {
            DataOutputStream dataOutputStream = this.outputStream;
            synchronized (dataOutputStream) {
                this.outputStream.writeInt(messageHolder.getMessage().length);
                this.outputStream.write(messageHolder.getMessage());
                this.outputStream.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transmitException(Exception e) throws IOException {
            DataOutputStream dataOutputStream = this.outputStream;
            synchronized (dataOutputStream) {
                StringBuffer sBuffer = new StringBuffer();
                StackTraceElement[] elements = e.getStackTrace();
                for (int indx = 0; indx < elements.length; ++indx) {
                    sBuffer.append(elements[indx].toString());
                }
                this.outputStream.write(sBuffer.toString().getBytes());
                this.outputStream.flush();
            }
        }

        private void handleMessage(Object object) {
            if (object instanceof SCTE130MessageHolder) {
                SCTE130SocketServer.this.addWorkToQueue(new ReadyWorkHolder(this, (SCTE130MessageHolder)object));
            }
        }

        public void run() {
            byte[] bArray = null;
            int amountRead = 0;
            int messageSize = 0;
            while (!this.stop) {
                int thisRead = 0;
                try {
                    if (messageSize == 0) {
                        messageSize = this.inputStream.readInt();
                        bArray = new byte[messageSize];
                    }
                    while (amountRead != messageSize) {
                        thisRead = this.inputStream.read(bArray, amountRead, messageSize - amountRead);
                        amountRead += thisRead;
                    }
                    if (amountRead != messageSize) continue;
                    SCTE130SocketServer.this.log.debug((Object)"Raw Message fulfilled.");
                    this.handleMessage(new SCTE130MessageHolder(bArray));
                    amountRead = 0;
                    messageSize = 0;
                }
                catch (SocketException se) {
                    this.shutdown();
                }
                catch (EOFException eofe) {
                    SCTE130SocketServer.this.log.debug((Object)"Socket shutdown detected.");
                    this.shutdown();
                }
                catch (IOException ioe) {
                    SCTE130SocketServer.this.log.error((Object)"Caught IOException reading input message from client socket stream.", (Throwable)ioe);
                    this.shutdown();
                }
            }
            SCTE130SocketServer.this.removeClient(this);
            SCTE130SocketServer.this.log.info((Object)"ClientSocketListener shutdown complete.");
        }
    }

    public static interface ClientSocketListener {
        public void shutdown();

        public void transmitMessage(SCTE130MessageHolder var1) throws IOException;

        public void transmitException(Exception var1) throws IOException;
    }

    public class MessageWorker
    extends Thread {
        private ClientSocketListener clientSocketListener = null;
        private SCTE130MessageHolder messageHolder = null;
        private Object alarm = new Object();
        private boolean started = false;
        private boolean stop = false;

        public void setup(ClientSocketListener clientSocketListener, SCTE130MessageHolder messageHolder) {
            this.clientSocketListener = clientSocketListener;
            this.messageHolder = messageHolder;
        }

        public void start() {
            if (!this.started) {
                super.start();
                this.started = true;
            }
            this.wakeOnAlarm();
            SCTE130SocketServer.this.log.debug((Object)"MessageWorker starts.");
        }

        public void shutdown() {
            this.stop = true;
            this.wakeOnAlarm();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                Object object = this.alarm;
                synchronized (object) {
                    if (this.clientSocketListener != null) {
                        SCTE130SocketServer.this.log.debug((Object)"Worker thread starts task.");
                        this.runJob();
                        SCTE130SocketServer.this.log.debug((Object)"Worker thread completes task.");
                    }
                    try {
                        this.alarm.wait();
                        SCTE130SocketServer.this.log.debug((Object)"Message worker wakes on alarm.");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            SCTE130SocketServer.this.log.info((Object)"Worker thread terminates.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runJob() {
            try {
                SCTE130SocketServer.this.messageHandler.handleMessage(this.clientSocketListener, this.messageHolder);
                this.clientSocketListener = null;
            }
            finally {
                SCTE130SocketServer.this.returnToPool(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeOnAlarm() {
            Object object = this.alarm;
            synchronized (object) {
                this.alarm.notify();
            }
        }
    }

    public class ReadyWorkHolder {
        private ClientSocketListener clientSocketListener = null;
        private SCTE130MessageHolder messageHolder = null;

        public ReadyWorkHolder(ClientSocketListener clientSocketListener, SCTE130MessageHolder messageHolder) {
            this.clientSocketListener = clientSocketListener;
            this.messageHolder = messageHolder;
        }

        public ClientSocketListener getClientSocketListener() {
            return this.clientSocketListener;
        }

        public SCTE130MessageHolder getMessageHolder() {
            return this.messageHolder;
        }
    }

    public class SocketAcceptor
    implements Runnable {
        private ServerSocket serverSocket = null;
        private boolean stop = false;

        public SocketAcceptor(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void shutdown() {
            this.stop = true;
        }

        public void run() {
            while (!this.stop) {
                try {
                    Socket socket = this.serverSocket.accept();
                    SCTE130SocketServer.this.manageSocket(socket);
                }
                catch (SocketException ignore) {
                }
                catch (IOException ioe) {
                    SCTE130SocketServer.this.log.error((Object)"Caught IOException accepting a socket connection.", (Throwable)ioe);
                }
            }
            SCTE130SocketServer.this.log.info((Object)"SCTE130SocketServer stopped.");
        }
    }

    public class WorkAssigner
    implements Runnable {
        private boolean stop = false;

        public void shutdown() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReadyWorkHolder workHolder = null;
            while (!this.stop) {
                ArrayList arrayList = SCTE130SocketServer.this.readyWorkQueue;
                synchronized (arrayList) {
                    if (SCTE130SocketServer.this.readyWorkQueue.size() > 0) {
                        workHolder = (ReadyWorkHolder)SCTE130SocketServer.this.readyWorkQueue.remove(SCTE130SocketServer.this.readyWorkQueue.size() - 1);
                    } else {
                        try {
                            SCTE130SocketServer.this.readyWorkQueue.wait(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (workHolder != null) {
                    MessageWorker worker = SCTE130SocketServer.this.allocateWorkerThread();
                    worker.setup(workHolder.getClientSocketListener(), workHolder.getMessageHolder());
                    worker.start();
                }
                workHolder = null;
            }
            SCTE130SocketServer.this.log.debug((Object)"Work assigner shutdown complete.");
        }
    }
}

