/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.servlet;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.messages.core.ServiceCheckRequest;
import com.ttv.SCTE130.messages.core.ServiceCheckResponse;
import com.ttv.SCTE130.utils.SCTE130Utils;
import com.ttv.SCTE130.utils.Serializer;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;

public class SCTE130Servlet
extends HttpServlet {
    public static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        System.out.println("SCTE130Servlet Starts.");
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            byte[] data = new byte[request.getContentLength()];
            ServletInputStream inputStream = request.getInputStream();
            int bytesRead = inputStream.read(data, 0, request.getContentLength());
            if (bytesRead != request.getContentLength()) {
                throw new Exception("Failed to read " + request.getContentLength() + " bytes of data.");
            }
            Element ele = SCTE130Utils.getElementFromByteArray(data);
            Serializer ser = new Serializer(System.out);
            ser.serialize(ele);
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(ele);
            MessageInterface message = (MessageInterface)factory.allocateSCTE130Message(ele);
            MessageInterface theResponse = null;
            if (message instanceof ServiceCheckRequest) {
                ServiceCheckRequest theRequest = (ServiceCheckRequest)message;
                theResponse = new ServiceCheckResponse("messageId", "ident", "system", theRequest.getMessageId(), null, null);
            }
            if (theResponse != null) {
                byte[] outputData = SCTE130Utils.SOAPElementToByteArray(theResponse.getSOAPElement());
                response.setContentLength(outputData.length);
                response.setContentType("text/xml");
                out.write(outputData);
            } else {
                System.out.println("The response is NULL.");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException ignore) {}
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("Handling HTTP POST request.");
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "A servlet to process SCTE130 Message Requests.";
    }
}

