/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.client.SCTE130Client;
import com.ttv.SCTE130.client.SCTE130ClientInterface;
import com.ttv.SCTE130.client.SCTE130HTTPClient;
import com.ttv.SCTE130.client.SCTE130SocketClient;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.Args;
import com.ttv.SCTE130.utils.Serializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.UnknownHostException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMessageSender {
    private String connectionType = null;

    public static void main(String[] args) {
        GenericMessageSender gms = new GenericMessageSender();
        Args.initialize(gms, args);
        gms.test(args);
    }

    public void test(String[] args) {
        int clients = 1;
        String url = null;
        String file = null;
        boolean verbose = false;
        ArrayList<Client> clientThreads = new ArrayList<Client>();
        try {
            if (Args.isOption("?") || Args.isOption("help")) {
                this.usage();
            }
            if (!Args.isOption("url")) {
                this.usage();
            } else {
                url = Args.getOptionArg("url");
            }
            if (!Args.isOption("file")) {
                this.usage();
            } else {
                file = Args.getOptionArg("file");
                File theFile = new File(file);
                if (!theFile.exists()) {
                    System.out.println("ERROR: Failed to locate file: " + file);
                    this.usage();
                }
            }
            if (Args.isOption("verbose")) {
                verbose = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.usage();
        }
        long totalTimeStart = System.currentTimeMillis();
        for (int indx = 0; indx < clients; ++indx) {
            Client client = new Client(url, file, verbose);
            client.start();
            clientThreads.add(client);
        }
        try {
            for (Client client : clientThreads) {
                client.join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        long totalTimeEnd = System.currentTimeMillis();
        this.postStatistics(clientThreads, url, totalTimeEnd - totalTimeStart);
        System.out.println("Processing complete.");
    }

    private void postStatistics(ArrayList<Client> clientThreads, String url, long totalRunTime) {
        System.out.println("---------------------------------------------------------------------");
        System.out.println(" URL            = " + url);
        System.out.println(" ConnectionType = " + this.connectionType);
        System.out.println(" Total run time = " + totalRunTime + " milliseconds.");
        System.out.println("---------------------------------------------------------------------");
    }

    public void usage() {
        System.out.println("Usage: GeneicMessageSender -url <System URL>");
        System.out.println("                           -file <source file>");
        System.out.println("                           -verbose");
        System.out.println("Example: GeneicMessageSender -url http://localhost/ADSServer/SOAPServiceEndpoint -file myfile.xml  // SOAP client");
        System.out.println("Example: GeneicMessageSender -url http://localhost/ADSServer/HTTPServiceEndpoint -file myfile.xml  // HTTP client");
        System.exit(1);
    }

    private class Client
    extends Thread {
        private int iterations = 1;
        private String url = null;
        private String file = null;
        private boolean verbose;
        private SCTE130ClientInterface client = null;

        public Client(String url, String file, boolean verbose) {
            this.url = url;
            this.file = file;
            this.verbose = verbose;
        }

        private SCTE130ClientInterface allocateClient(String uri) throws MalformedURLException, UnknownHostException, IOException {
            URL url = new URL(uri);
            if (url.toString().contains("SOAPServiceEndpoint")) {
                GenericMessageSender.this.connectionType = "SOAP";
                this.client = new SCTE130Client();
                ((SCTE130Client)this.client).setCallOptions(null);
                ((SCTE130Client)this.client).setDestinationURL(uri);
                ((SCTE130Client)this.client).setLoginPassword("admin", "administrator");
            } else if (url.toString().contains("HTTPServiceEndpoint")) {
                GenericMessageSender.this.connectionType = "HTTP/XML";
                this.client = new SCTE130HTTPClient(url.toString(), "admin", "administrator");
            } else {
                GenericMessageSender.this.connectionType = "SOCKET";
                this.client = new SCTE130SocketClient(url.getHost(), url.getPort());
                ((SCTE130SocketClient)this.client).connect();
            }
            return this.client;
        }

        public void run() {
            MessageInterface request = null;
            try {
                request = this.parseFile(this.file);
            }
            catch (Exception e) {
                e.printStackTrace();
                GenericMessageSender.this.usage();
            }
            try {
                this.client = this.allocateClient(this.url);
            }
            catch (MalformedURLException mal) {
                mal.printStackTrace();
                GenericMessageSender.this.usage();
            }
            catch (Exception e) {
                e.printStackTrace();
                GenericMessageSender.this.usage();
            }
            for (int indx = 0; indx < this.iterations; ++indx) {
                try {
                    Element ret = this.client.invoke(request.getSOAPElement());
                    if (!this.verbose) continue;
                    Serializer s = new Serializer(new PrintWriter(System.out));
                    s.serialize(ret);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Failed to send message to target system: " + this.url);
                    e.printStackTrace();
                }
            }
            this.client.disconnect();
        }

        private MessageInterface parseFile(String file) throws Exception {
            MessageInterface message = null;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(file));
            Element element = doc.getDocumentElement();
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(element);
            message = (MessageInterface)factory.allocateSCTE130Message(element);
            return message;
        }
    }
}

