/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test;

import com.ttv.SCTE130.client.SCTE130Client;
import com.ttv.SCTE130.client.SCTE130ClientInterface;
import com.ttv.SCTE130.client.SCTE130HTTPClient;
import com.ttv.SCTE130.client.SCTE130SocketClient;
import com.ttv.SCTE130.messages.adm.PlacementRequest;
import com.ttv.SCTE130.utils.Args;
import com.ttv.SCTE130.utils.Serializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacementRequestTestFile {
    private String connectionType = null;

    public static void main(String[] args) {
        PlacementRequestTestFile prtf = new PlacementRequestTestFile();
        Args.initialize(prtf, args);
        prtf.test(args);
    }

    public void test(String[] args) {
        int clients = 1;
        int iterations = 1;
        int frequency = 1;
        String url = null;
        String file = null;
        String statsFile = null;
        boolean verbose = false;
        ArrayList<Client> clientThreads = new ArrayList<Client>();
        try {
            if (Args.isOption("?") || Args.isOption("help")) {
                this.usage();
            }
            if (!Args.isOption("url")) {
                this.usage();
            } else {
                url = Args.getOptionArg("url");
            }
            if (!Args.isOption("file")) {
                this.usage();
            } else {
                file = Args.getOptionArg("file");
                File theFile = new File(file);
                if (!theFile.exists()) {
                    System.out.println("ERROR: Failed to locate file: " + file);
                    this.usage();
                }
            }
            if (Args.isOption("stats")) {
                statsFile = Args.getOptionArg("stats");
            }
            if (Args.isOption("clients")) {
                clients = Integer.parseInt(Args.getOptionArg("clients"));
            }
            if (Args.isOption("iterations")) {
                iterations = Integer.parseInt(Args.getOptionArg("iterations"));
            }
            if (Args.isOption("frequency")) {
                frequency = Integer.parseInt(Args.getOptionArg("frequency"));
            }
            if (Args.isOption("verbose")) {
                verbose = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.usage();
        }
        long totalTimeStart = System.currentTimeMillis();
        for (int indx = 0; indx < clients; ++indx) {
            Client client = new Client(url, file, iterations, frequency, verbose);
            client.start();
            clientThreads.add(client);
        }
        try {
            for (Client client : clientThreads) {
                client.join();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        long totalTimeEnd = System.currentTimeMillis();
        this.postStatistics(clientThreads, clients, iterations, frequency, url, totalTimeEnd - totalTimeStart, statsFile);
        System.out.println("Processing complete.");
    }

    private void postStatistics(ArrayList<Client> clientThreads, int clients, int iterations, int frequency, String url, long totalRunTime, String statsFile) {
        int onTime = 0;
        int offTime = 0;
        ArrayList<Long> executionTimes = new ArrayList<Long>();
        File statisticsFile = null;
        FileOutputStream fos = null;
        for (Client client : clientThreads) {
            Stats stats = client.getStats();
            onTime += stats.getOnTime();
            offTime += stats.getOffTime();
            executionTimes.addAll(stats.getExecutionTimes());
        }
        Long max = new Long(0L);
        Long min = new Long(Integer.MAX_VALUE);
        Long totalTime = new Long(0L);
        Long averageTime = new Long(0L);
        Long adjustedMax = new Long(0L);
        Long adjustedMin = new Long(Integer.MAX_VALUE);
        Long adjustedTotalTime = new Long(0L);
        Long adjustedAverageTime = new Long(0L);
        if (statsFile != null) {
            try {
                statisticsFile = new File(statsFile);
                fos = new FileOutputStream(statisticsFile);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Failed to create stats output file. Bailing.");
                System.exit(1);
            }
        }
        String eol = System.getProperty("line.separator");
        int indx = 1;
        for (Long time : executionTimes) {
            if (time > max) {
                max = time;
            }
            if (time < min) {
                min = time;
            }
            totalTime = totalTime + time;
            if (fos != null) {
                String statsString = indx + " " + time.intValue() + eol;
                try {
                    fos.write(statsString.getBytes());
                }
                catch (IOException ioe) {
                    System.out.println("Failed to log to stats output file. Bailing.");
                    System.exit(1);
                }
            }
            ++indx;
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        averageTime = totalTime / (long)executionTimes.size();
        long highWaterMark = min * 10L;
        int valuesIgnored = 0;
        for (Long time : executionTimes) {
            if (time >= highWaterMark) {
                ++valuesIgnored;
                continue;
            }
            if (time > adjustedMax) {
                adjustedMax = time;
            }
            if (time < adjustedMin) {
                adjustedMin = time;
            }
            adjustedTotalTime = adjustedTotalTime + time;
        }
        adjustedAverageTime = adjustedTotalTime / (long)(executionTimes.size() > 2 ? executionTimes.size() - 2 : 1);
        System.out.println("---------------------------------------------------------------------");
        System.out.println(" URL             = " + url);
        System.out.println(" Connection Type = " + this.connectionType);
        System.out.println("");
        System.out.println(" Clients    = " + clients);
        System.out.println(" Iterations = " + iterations);
        System.out.println(" Frequency  = " + frequency + " calls per second.");
        System.out.println(" Allocated time per call: " + 1000 / frequency + " milliseconds.");
        System.out.println(" Total run time = " + totalRunTime + " milliseconds.");
        System.out.println("");
        System.out.println(" Number of calls performed on time: " + onTime);
        System.out.println(" Number of calls that ran over time: " + offTime);
        System.out.println(" Percentage successful: " + (float)onTime / (float)executionTimes.size() * 100.0f + "%");
        System.out.println("");
        System.out.println(" Average call time: " + averageTime + " milliseconds.");
        System.out.println(" Maximum call time: " + max + " milliseconds.");
        System.out.println(" Minimum call time: " + min + " milliseconds.");
        System.out.println("");
        System.out.println(" Adjusted Average call time: " + adjustedAverageTime + " milliseconds.");
        System.out.println(" Adjusted Maximum call time: " + adjustedMax + " milliseconds.");
        System.out.println(" Adjusted Minimum call time: " + adjustedMin + " milliseconds.");
        System.out.println(" Number of culled adjusted values: " + valuesIgnored + " High water mark: " + highWaterMark + " milliseconds.");
        System.out.println(" Percentage of culled to accepted values: " + (float)valuesIgnored / (float)executionTimes.size() * 100.0f + "%");
        if (statsFile != null) {
            System.out.println("");
            System.out.println(" Stats written to file: " + statsFile);
        }
        System.out.println("---------------------------------------------------------------------");
    }

    public void usage() {
        System.out.println("Usage: PlacementRequestTestFile -url <ADS URL>");
        System.out.println("                                -file <source file>");
        System.out.println("                                -clients <number of clients>");
        System.out.println("                                -iterations <number of calls to make>");
        System.out.println("                                -frequency <calls per second>");
        System.out.println("                                -stats <output file>");
        System.out.println("                                -verbose");
        System.out.println("Example: PlacementRequestTestFile -url http://localhost/ADSServer/SOAPServiceEndpoint -file myfile.xml -clients 1 -iterations 50 -frequency 10 // SOAP client");
        System.out.println("Example: PlacementRequestTestFile -url http://localhost/ADSServer/HTTPServiceEndpoint -file myfile.xml -clients 1 -iterations 50 -frequency 10 // HTTP client");
        System.exit(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Stats {
        private int iterations = 0;
        private int onTime = 0;
        private ArrayList<Long> executionTimes = new ArrayList();

        public void addOntime() {
            ++this.onTime;
        }

        public void addExecutionTime(long time) {
            this.executionTimes.add(new Long(time));
        }

        public void addIteration() {
            ++this.iterations;
        }

        public int getOnTime() {
            return this.onTime;
        }

        public int getOffTime() {
            return this.iterations - this.onTime;
        }

        public List<Long> getExecutionTimes() {
            return this.executionTimes;
        }

        public int getIterations() {
            return this.iterations;
        }
    }

    private class Client
    extends Thread {
        private String url = null;
        private String file = null;
        private int iterations;
        private int frequency;
        private long allotedRunTime;
        private boolean verbose;
        private SCTE130ClientInterface client = null;
        private Stats stats = null;

        public Client(String url, String file, int iterations, int frequency, boolean verbose) {
            this.url = url;
            this.file = file;
            this.iterations = iterations;
            this.frequency = frequency;
            this.verbose = verbose;
            this.allotedRunTime = 1000 / this.frequency;
            this.stats = new Stats();
        }

        private SCTE130ClientInterface allocateClient(String uri) throws MalformedURLException, UnknownHostException, IOException {
            URL url = new URL(uri);
            if (url.toString().contains("SOAPServiceEndpoint")) {
                PlacementRequestTestFile.this.connectionType = "SOAP";
                this.client = new SCTE130Client();
                ((SCTE130Client)this.client).setCallOptions(null);
                ((SCTE130Client)this.client).setDestinationURL(uri);
                ((SCTE130Client)this.client).setLoginPassword("admin", "administrator");
            } else if (url.toString().contains("HTTPServiceEndpoint")) {
                PlacementRequestTestFile.this.connectionType = "HTTP/XML";
                this.client = new SCTE130HTTPClient(url.toString(), "admin", "administrator");
            } else {
                PlacementRequestTestFile.this.connectionType = "SOCKET";
                this.client = new SCTE130SocketClient(url.getHost(), url.getPort());
                ((SCTE130SocketClient)this.client).connect();
            }
            return this.client;
        }

        public void run() {
            PlacementRequest request = null;
            try {
                request = this.parseFile(this.file);
            }
            catch (Exception e) {
                e.printStackTrace();
                PlacementRequestTestFile.this.usage();
            }
            try {
                this.client = this.allocateClient(this.url);
            }
            catch (MalformedURLException mal) {
                mal.printStackTrace();
                PlacementRequestTestFile.this.usage();
            }
            catch (Exception e) {
                e.printStackTrace();
                PlacementRequestTestFile.this.usage();
            }
            for (int indx = 0; indx < this.iterations; ++indx) {
                long callTime;
                long endTime;
                long startTime;
                block11: {
                    startTime = 0L;
                    endTime = 0L;
                    callTime = 0L;
                    try {
                        startTime = System.currentTimeMillis();
                        Element ret = this.client.invoke(request.getSOAPElement());
                        endTime = System.currentTimeMillis();
                        if (!this.verbose) break block11;
                        Serializer s = new Serializer(new PrintWriter(System.out));
                        s.serialize(ret);
                    }
                    catch (Exception e) {
                        System.out.println("Failed to send PlacementRequest to target system: " + this.url);
                        e.printStackTrace();
                        this.stats.addIteration();
                        continue;
                    }
                }
                callTime = endTime - startTime;
                if (callTime < this.allotedRunTime) {
                    long timeRemaining = this.allotedRunTime - callTime;
                    this.stats.addExecutionTime(callTime);
                    this.stats.addOntime();
                    this.stats.addIteration();
                    try {
                        Thread.sleep(timeRemaining);
                    }
                    catch (Exception ignore) {}
                    continue;
                }
                this.stats.addExecutionTime(callTime);
                this.stats.addIteration();
            }
            this.client.disconnect();
        }

        public Stats getStats() {
            return this.stats;
        }

        private PlacementRequest parseFile(String file) throws Exception {
            PlacementRequest placementRequest = null;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(file));
            placementRequest = new PlacementRequest(doc.getDocumentElement());
            return placementRequest;
        }
    }
}

