/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test;

import com.ttv.SCTE130.SCTE130Namespaces;
import com.ttv.SCTE130.client.SCTE130SocketClient;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.ContentProvider;
import com.ttv.SCTE130.messages.adm.EffectiveEndDateTime;
import com.ttv.SCTE130.messages.adm.EffectiveStartDateTime;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.adm.MaxDuration;
import com.ttv.SCTE130.messages.adm.MaxPlacementCount;
import com.ttv.SCTE130.messages.adm.MinDuration;
import com.ttv.SCTE130.messages.adm.MinPlacementCount;
import com.ttv.SCTE130.messages.adm.OpportunityBinding;
import com.ttv.SCTE130.messages.adm.OpportunityConstraints;
import com.ttv.SCTE130.messages.adm.PlacementControl;
import com.ttv.SCTE130.messages.adm.PlacementCount;
import com.ttv.SCTE130.messages.adm.PlacementDateTime;
import com.ttv.SCTE130.messages.adm.PlacementDecisionOwner;
import com.ttv.SCTE130.messages.adm.PlacementOpportunity;
import com.ttv.SCTE130.messages.adm.PlacementRequest;
import com.ttv.SCTE130.messages.adm.ProductType;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.adm.TargetCode;
import com.ttv.SCTE130.messages.adm.TerminalAddress;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.AssetRef;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Program;
import com.ttv.SCTE130.messages.core.Tracking;
import com.ttv.SCTE130.utils.Serializer;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;

public class PlacementRequestTransmissionTest {
    public static void main(String[] args) {
        PlacementRequestTransmissionTest art = new PlacementRequestTransmissionTest();
        art.test(args);
    }

    public void test(String[] args) {
        SCTE130SocketClient client = new SCTE130SocketClient("10.250.30.22", 5659);
        try {
            client.connect();
            PlacementRequest availRequest = PlacementRequestTransmissionTest.createPlacementRequest(args);
            SOAPElement element = availRequest.getSOAPElement();
            SCTE130Namespaces.getInstance().populateNamespace(element, "adm");
            long start = System.currentTimeMillis();
            Element ret = client.invoke(element);
            long end = System.currentTimeMillis();
            System.out.println("Elapsed time: " + (end - start) + " milliseconds.");
            Serializer s = new Serializer(System.out);
            s.serialize(ret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PlacementRequest createPlacementRequest(String[] args) throws SOAPException, Exception {
        AssetRef assetRef = new AssetRef(args[0], args[1]);
        ProductType productType = new ProductType("MOD");
        ContentProvider provider = new ContentProvider(args[1], new ContentDataModel("CLADI_1.1", "http://www.cablelabs.com/<date>/ADI1.1"));
        Scope scope = new Scope("Local");
        AdType adType = new AdType("Interstitial");
        PlacementDecisionOwner owner = new PlacementDecisionOwner("Allen Smithy");
        Content content = new Content("1", assetRef, new Duration("PT30M"), adType, null, new Tracking("12345"), null);
        Entertainment entertainment = new Entertainment(content, new EntertainmentNPT("0", 1.0), null);
        CurrentDateTime currentDateTime = new CurrentDateTime(new Date());
        ArrayList<TargetCode> targetCodeList = new ArrayList<TargetCode>();
        targetCodeList.add(new TargetCode("30096", "ZipPlus4"));
        TerminalAddress terminalAddress = new TerminalAddress("3c:3c:3c:3c", "MAC");
        Client client = new Client(currentDateTime, targetCodeList, terminalAddress, null);
        Program program = new Program(101, new CurrentDateTime(new Date()));
        ArrayList<Service> serviceList = new ArrayList<Service>();
        serviceList.add(new Service("1", "interactive", "pre-roll", program, adType, provider, productType, owner, scope, null));
        MinPlacementCount minC = new MinPlacementCount(1);
        MaxPlacementCount maxC = new MaxPlacementCount(2);
        PlacementCount count = new PlacementCount(1);
        SystemContext systemContext = new SystemContext(null, null, null, null, null, null);
        Duration duration = new Duration("PT33S");
        MinDuration minDuration = new MinDuration("PT33S");
        MaxDuration maxDuration = new MaxDuration("PT66S");
        EffectiveStartDateTime start = new EffectiveStartDateTime(new Date());
        EffectiveEndDateTime end = new EffectiveEndDateTime(new Date());
        OpportunityConstraints constraints = new OpportunityConstraints();
        constraints.setAdType(adType);
        constraints.setScope(scope);
        ArrayList<PlacementControl> placementControlList = new ArrayList<PlacementControl>();
        placementControlList.add(new PlacementControl("id1", "Fill", 1, null, constraints, new PlacementDateTime(new Date()), null));
        OpportunityBinding oppyBinding1 = new OpportunityBinding("Interstitial", 1, 3);
        OpportunityBinding oppyBinding2 = new OpportunityBinding("Interstitial", 2, 3);
        OpportunityBinding oppyBinding3 = new OpportunityBinding("Interstitial", 3, 3);
        ArrayList<PlacementOpportunity> oppies = new ArrayList<PlacementOpportunity>();
        oppies.add(new PlacementOpportunity("id1", "regRef", "localRef", oppyBinding1, constraints, new PlacementDateTime(new Date()), placementControlList, null));
        oppies.add(new PlacementOpportunity("id1", "regRef", "localRef", oppyBinding2, constraints, new PlacementDateTime(new Date()), placementControlList, null));
        oppies.add(new PlacementOpportunity("id1", "regRef", "localRef", oppyBinding3, constraints, new PlacementDateTime(new Date()), placementControlList, null));
        PlacementRequest pr = new PlacementRequest("id", "identity", "system", false, systemContext, serviceList, entertainment, client, null, oppies, null);
        return pr;
    }
}

