/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.client.SCTE130Client;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.adm.Event;
import com.ttv.SCTE130.messages.adm.Events;
import com.ttv.SCTE130.messages.adm.NPT;
import com.ttv.SCTE130.messages.adm.PlacementStatusAcknowledgement;
import com.ttv.SCTE130.messages.adm.PlacementStatusNotification;
import com.ttv.SCTE130.messages.adm.PlayData;
import com.ttv.SCTE130.messages.adm.Spot;
import com.ttv.SCTE130.messages.adm.SpotNPT;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.adm.TargetCode;
import com.ttv.SCTE130.messages.adm.TerminalAddress;
import com.ttv.SCTE130.messages.adm.ViewerEvent;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.AssetRef;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Note;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.messages.core.Tracking;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;

public class PlacementStatusNotificationTransmissionTest {
    public static void main(String[] args) {
        PlacementStatusNotificationTransmissionTest psnt = new PlacementStatusNotificationTransmissionTest();
        psnt.test(args);
    }

    public void test(String[] args) {
        SCTE130Client client = new SCTE130Client();
        client.setCallOptions(args);
        client.setDestinationURL("http://localhost/ADSServer");
        client.setLoginPassword("admin", "administrator");
        try {
            PlacementStatusNotification psn = PlacementStatusNotificationTransmissionTest.createPlacementStatusNotification(args);
            Element resp = client.invoke(psn.getSOAPElement());
            SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(resp);
            PlacementStatusAcknowledgement psa = (PlacementStatusAcknowledgement)factory.allocateSCTE130Message(resp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PlacementStatusNotification createPlacementStatusNotification(String[] args) throws SOAPException, Exception {
        SystemContext systemContext = new SystemContext(null, null, null, null, null, null);
        ArrayList<Note> noteList = new ArrayList<Note>();
        noteList.add(new Note("Hello World"));
        StatusCode statusCode = new StatusCode(0, 0, noteList, null);
        Tracking tracking = new Tracking("Tracking");
        Content content = new Content("Id", new AssetRef("AssetId", "ProviderId"), new Duration("00:30:00.000"), new AdType("AdType"), null, tracking, null);
        Spot spot = new Spot(tracking, content, new SpotNPT("00:00", 1.0), null);
        Entertainment entertainment = new Entertainment(content, new EntertainmentNPT("00:00", 1.0), null);
        ArrayList<TargetCode> targetCodes = new ArrayList<TargetCode>();
        targetCodes.add(new TargetCode("key", "value"));
        TerminalAddress terminalAddress = new TerminalAddress("Address", "Type");
        Client client = new Client(new CurrentDateTime(new Date()), targetCodes, terminalAddress, null);
        ArrayList<Event> eventList = new ArrayList<Event>();
        eventList.add(new ViewerEvent("Play", new Date(), "identity", "systemADM", "identityADS", "messageRef", "remote", statusCode, systemContext, client, entertainment, spot, new NPT("00:00", 1.0), null));
        Events events = new Events(eventList, new Date(), new Date(), null);
        ArrayList<PlayData> playDataItems = new ArrayList<PlayData>();
        playDataItems.add(new PlayData("identityADM", "systemADM", "identityADS", new Date(), new Date(), systemContext, client, null, null, events, null));
        PlacementStatusNotification psn = new PlacementStatusNotification("1-2345", "identity", "system", playDataItems, null);
        return psn;
    }
}

