/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test.junit;

import com.ttv.SCTE130.messages.adm.ADMData;
import com.ttv.SCTE130.messages.adm.Channel;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.ContentProvider;
import com.ttv.SCTE130.messages.adm.EffectiveEndDateTime;
import com.ttv.SCTE130.messages.adm.EffectiveStartDateTime;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.adm.Network;
import com.ttv.SCTE130.messages.adm.OpportunityBinding;
import com.ttv.SCTE130.messages.adm.Placement;
import com.ttv.SCTE130.messages.adm.PlacementConstraints;
import com.ttv.SCTE130.messages.adm.PlacementDecision;
import com.ttv.SCTE130.messages.adm.PlacementDecisionOwner;
import com.ttv.SCTE130.messages.adm.PlacementResponse;
import com.ttv.SCTE130.messages.adm.ProductType;
import com.ttv.SCTE130.messages.adm.Scope;
import com.ttv.SCTE130.messages.adm.Service;
import com.ttv.SCTE130.messages.adm.ServiceGroup;
import com.ttv.SCTE130.messages.adm.Session;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.adm.TargetCode;
import com.ttv.SCTE130.messages.adm.TerminalAddress;
import com.ttv.SCTE130.messages.adm.Zone;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.AssetRef;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.ContentDataModel;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Note;
import com.ttv.SCTE130.messages.core.Program;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.messages.core.Tracking;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import org.w3c.dom.Element;

public class PlacementResponseTest
extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testPlacementResponse() {
        ArrayList<Note> notesList = new ArrayList<Note>();
        notesList.add(new Note("Note 1"));
        notesList.add(new Note("Note 2"));
        Scope scope = new Scope("scope");
        ArrayList<AdType> adTypes = new ArrayList<AdType>();
        adTypes.add(new AdType("AdType"));
        AssetRef assetRef = new AssetRef("AssetId", "ProviderId");
        AdType adType = new AdType("AdType");
        Duration duration = new Duration("PT10.000S");
        Tracking tracking = new Tracking("Tracking");
        Content content = new Content("id", assetRef, duration, adType, null, tracking, null);
        Entertainment entertainment = new Entertainment(content, new EntertainmentNPT("0", 1.0), null);
        ArrayList<TargetCode> targetCodes = new ArrayList<TargetCode>();
        targetCodes.add(new TargetCode("key", "value"));
        EffectiveStartDateTime start = new EffectiveStartDateTime(new Date());
        EffectiveEndDateTime end = new EffectiveEndDateTime(new Date());
        PlacementConstraints constraints = new PlacementConstraints(duration, start, end, scope, null);
        ArrayList<Placement> placementList = new ArrayList<Placement>();
        placementList.add(new Placement("id", "Fill", "ControlRef", 1, tracking, content, constraints, null));
        StatusCode statusCode = new StatusCode(0, 0, notesList, null);
        OpportunityBinding opportunityBinding = new OpportunityBinding("Avail", 1, 1);
        ArrayList<PlacementDecision> placementDecisionList = new ArrayList<PlacementDecision>();
        placementDecisionList.add(new PlacementDecision("Id", "oppy", "", opportunityBinding, constraints, placementList, null));
        ServiceGroup serviceGroup = new ServiceGroup("12345");
        Network network = new Network("network");
        Channel channel = new Channel("11-Alive");
        Zone zone = new Zone("zone");
        Session session = new Session("session-1");
        SystemContext systemContext = new SystemContext(serviceGroup, network, channel, zone, session, null);
        TerminalAddress terminalAddress = new TerminalAddress("3c:3c:3c:3c:3c", "MAC");
        Client client = new Client(new CurrentDateTime(new Date()), targetCodes, terminalAddress, null);
        Program program = new Program(101, new CurrentDateTime(new Date()));
        ContentProvider contentProvider = new ContentProvider("provider", new ContentDataModel("CLADI_1.1", "http://www.cablelabs.com/<date>/ADI1.1"));
        ProductType productType = new ProductType("MOD");
        PlacementDecisionOwner owner = new PlacementDecisionOwner("Walt");
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(new Service("id", "interactive", "pre-roll", program, adType, contentProvider, productType, owner, scope, null));
        try {
            PlacementResponse resp1 = new PlacementResponse("id", "identity", "sys", "messageRef", statusCode, systemContext, services, entertainment, client, new ADMData("Hello World"), placementDecisionList, null);
            PlacementResponse resp2 = new PlacementResponse((Element)resp1.getSOAPElement());
            if (!resp1.equals(resp2)) {
                PlacementResponseTest.fail((String)"PlacementResponse messages don't match");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PlacementResponseTest.fail((String)"Caught exception");
        }
    }
}

