/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.test.junit;

import com.ttv.SCTE130.messages.adm.Channel;
import com.ttv.SCTE130.messages.adm.Client;
import com.ttv.SCTE130.messages.adm.Entertainment;
import com.ttv.SCTE130.messages.adm.EntertainmentNPT;
import com.ttv.SCTE130.messages.adm.Event;
import com.ttv.SCTE130.messages.adm.Events;
import com.ttv.SCTE130.messages.adm.NPT;
import com.ttv.SCTE130.messages.adm.Network;
import com.ttv.SCTE130.messages.adm.PlacementStatusNotification;
import com.ttv.SCTE130.messages.adm.PlayData;
import com.ttv.SCTE130.messages.adm.ServiceGroup;
import com.ttv.SCTE130.messages.adm.Session;
import com.ttv.SCTE130.messages.adm.SessionEvent;
import com.ttv.SCTE130.messages.adm.Spot;
import com.ttv.SCTE130.messages.adm.SpotNPT;
import com.ttv.SCTE130.messages.adm.SystemContext;
import com.ttv.SCTE130.messages.adm.TargetCode;
import com.ttv.SCTE130.messages.adm.TerminalAddress;
import com.ttv.SCTE130.messages.adm.Zone;
import com.ttv.SCTE130.messages.core.AdType;
import com.ttv.SCTE130.messages.core.AssetRef;
import com.ttv.SCTE130.messages.core.Content;
import com.ttv.SCTE130.messages.core.CurrentDateTime;
import com.ttv.SCTE130.messages.core.Duration;
import com.ttv.SCTE130.messages.core.Note;
import com.ttv.SCTE130.messages.core.StatusCode;
import com.ttv.SCTE130.messages.core.Tracking;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import org.w3c.dom.Element;

public class PlacementStatusNotificationTest
extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testPlacementStatusNotification() {
        ArrayList<Note> notesList = new ArrayList<Note>();
        notesList.add(new Note("Note 1"));
        notesList.add(new Note("Note 2"));
        AssetRef assetRef = new AssetRef("AssetId", "ProviderId");
        AdType adType = new AdType("AdType");
        Duration duration = new Duration("PT10.000S");
        Tracking tracking = new Tracking("Tracking");
        NPT npt = new NPT("00:00", 1.0);
        Content content = new Content("id", assetRef, duration, adType, null, tracking, null);
        ServiceGroup serviceGroup = new ServiceGroup("ServiceGroup");
        Session session = new Session("Session");
        Zone zone = new Zone("Zone");
        Network network = new Network("Network");
        Channel channel = new Channel("11 Alive");
        ArrayList<TargetCode> targetCodeList = new ArrayList<TargetCode>();
        targetCodeList.add(new TargetCode("key", "value"));
        TerminalAddress terminalAddress = new TerminalAddress("Address", "URL");
        SystemContext systemContext = new SystemContext(serviceGroup, network, channel, zone, session, null);
        StatusCode statusCode = new StatusCode(0, 0, notesList, null);
        Entertainment entertainment = new Entertainment(content, new EntertainmentNPT("00:00", 1.0), null);
        Spot spot = new Spot(tracking, content, new SpotNPT("00:00", 1.0), null);
        Client client = new Client(new CurrentDateTime(new Date()), targetCodeList, terminalAddress, null);
        ArrayList<Event> eventList = new ArrayList<Event>();
        eventList.add(new SessionEvent("startSession", new Date(), "identityADM", "systemADM", "identityADS", "messageRef", statusCode, systemContext, client, entertainment, spot, npt, null));
        Events events = new Events(eventList, new Date(), new Date(), null);
        ArrayList<PlayData> playDataItems = new ArrayList<PlayData>();
        playDataItems.add(new PlayData("identityADM", "systemADM", "identityADS", new Date(), new Date(), systemContext, client, null, null, events, null));
        try {
            PlacementStatusNotification not1 = new PlacementStatusNotification("id", "identity", "system", playDataItems, null);
            PlacementStatusNotification not2 = new PlacementStatusNotification((Element)not1.getSOAPElement());
            if (!not1.equals(not2)) {
                PlacementStatusNotificationTest.fail((String)"PlacementStatusNotification messages don't match");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PlacementStatusNotificationTest.fail((String)"Caught exception");
        }
    }
}

