/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.utils;

import com.ttv.SCTE130.SCTE130MessageFactory;
import com.ttv.SCTE130.SCTE130MessageFactoryLocator;
import com.ttv.SCTE130.messages.MessageInterface;
import com.ttv.SCTE130.utils.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTE130Utils {
    private boolean devLogging = false;
    public static final String DEV_LOGGING = "DEV_LOGGING";
    public static SCTE130Utils instance = null;
    private static final String CHAR_ENCODING = "UTF-8";
    private Logger log = Logger.getLogger(SCTE130Utils.class);

    public static TreeMap<String, String> locateOtherAttributes(String[] excludeNameArray, NamedNodeMap nodeMap) {
        TreeMap<String, String> anyAttributes = new TreeMap<String, String>();
        List<String> excludeList = Arrays.asList(excludeNameArray);
        for (int indx = 0; indx < nodeMap.getLength(); ++indx) {
            Node node = nodeMap.item(indx);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (excludeList.contains(name)) continue;
            anyAttributes.put(name, value);
        }
        return anyAttributes;
    }

    public static void addOtherAttributes(SOAPElement element, TreeMap<String, String> attributes) {
        for (String name : attributes.keySet()) {
            String value = attributes.get(name);
            SCTE130Utils.setAttribute(element, name, value);
        }
    }

    public static void setAttribute(SOAPElement element, String attrName, String attribute) {
        if (attribute != null) {
            element.setAttribute(attrName, attribute);
        }
    }

    public static void addChildElement(SOAPElement parent, MessageInterface child) throws SOAPException {
        if (child != null) {
            parent.addChildElement(child.getSOAPElement());
        }
    }

    public static void addChildElementList(SOAPElement parent, List children) throws SOAPException {
        if (children != null) {
            for (int indx = 0; indx < children.size(); ++indx) {
                MessageInterface message = (MessageInterface)children.get(indx);
                parent.addChildElement(message.getSOAPElement());
            }
        }
    }

    public static SCTE130Utils getInstance() {
        if (instance == null) {
            instance = new SCTE130Utils();
        }
        return instance;
    }

    private SCTE130Utils() {
        if (System.getProperty(DEV_LOGGING) != null) {
            this.devLogging = true;
        }
    }

    public void devLog(String logMessage) {
        System.out.println("** " + logMessage + " **");
        if (this.devLogging) {
            this.log.debug((Object)logMessage);
        }
    }

    public static boolean stringsEqual(String str1, String str2) {
        if (str1 == null && str2 != null) {
            return str2.length() == 0;
        }
        if (str1 != null && str2 == null) {
            return str1.length() == 0;
        }
        return str1.equals(str2);
    }

    public static boolean objectsEqual(MessageInterface obj1, MessageInterface obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null && obj2 != null) {
            return false;
        }
        if (obj1 != null && obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean listsEqual(List list1, List list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null && list2 != null) {
            return list2.size() == 0;
        }
        if (list1 != null && list2 == null) {
            return list1.size() == 0;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int indx = 0; indx < list1.size(); ++indx) {
            MessageInterface list2Item;
            MessageInterface list1Item = (MessageInterface)list1.get(indx);
            if (list1Item.equals(list2Item = (MessageInterface)list2.get(indx))) continue;
            return false;
        }
        return true;
    }

    public static String removeNamespace(String elementName) {
        String modifiedName = elementName;
        if (modifiedName.indexOf(58) != -1) {
            modifiedName = modifiedName.substring(modifiedName.indexOf(58) + 1);
        }
        return modifiedName;
    }

    public static byte[] SOAPElementToByteArray(SOAPElement element) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, CHAR_ENCODING);
        Serializer serializer = new Serializer(writer);
        serializer.serialize((Element)element);
        return baos.toByteArray();
    }

    public static Element getElementFromByteArray(byte[] message) throws IOException, SAXException, Exception {
        DocumentBuilder parser = null;
        Document doc = null;
        if (parser == null) {
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
        }
        doc = parser.parse(new ByteArrayInputStream(message));
        return doc.getDocumentElement();
    }

    public static Object getObjectFromByteArray(byte[] message) throws IOException, SAXException, Exception {
        DocumentBuilder parser = null;
        Document doc = null;
        if (parser == null) {
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
        }
        doc = parser.parse(new ByteArrayInputStream(message));
        SCTE130MessageFactory factory = SCTE130MessageFactoryLocator.getMessageFactory(doc.getDocumentElement());
        return factory.allocateSCTE130Message(doc.getDocumentElement());
    }

    public static void installConsoleAppender(Logger log) {
        boolean consoleAppenderInstalled = false;
        Enumeration appenders = log.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof ConsoleAppender)) continue;
            consoleAppenderInstalled = true;
        }
        if (!consoleAppenderInstalled) {
            log.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        }
    }
}

