/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.SCTE130.validator;

import java.io.File;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidator {
    public static String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public XMLValidator(String xmlDocument, String xsdSchema) {
        this.validate(xmlDocument, xsdSchema);
    }

    public void validate(String xmlDocument, String xsdSchema) {
        System.out.println("Validating document: " + xmlDocument + " against schema: " + xsdSchema);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            try {
                factory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
                factory.setAttribute(SCHEMA_SOURCE, new File(xsdSchema));
            }
            catch (IllegalArgumentException x) {
                System.err.println("DOM parser not JAXP 1.2 compliant.");
            }
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(new ErrorPrinter());
            Document document = parser.parse(new File(xmlDocument));
            System.out.println("Schema and Instance validation complete.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            XMLValidator.usage();
        }
        XMLValidator xmlvd = new XMLValidator(args[0], args[1]);
    }

    public static void usage() {
        System.out.println("Usage: XMLValidator xmlInstance.xml xsdSchema.xsd");
        System.exit(1);
    }

    public class ErrorPrinter
    extends DefaultHandler {
        private MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");

        private void print(SAXParseException x) {
            String msg = this.message.format(new Object[]{x.getSystemId(), new Integer(x.getLineNumber()), new Integer(x.getColumnNumber()), x.getMessage()});
            System.out.println(msg);
        }

        public void warning(SAXParseException x) {
            this.print(x);
        }

        public void error(SAXParseException x) {
            this.print(x);
        }

        public void fatalError(SAXParseException x) throws SAXParseException {
            this.print(x);
            throw x;
        }
    }
}

