/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc.soap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import org.jboss.logging.Logger;
import org.jboss.util.id.SerialVersion;

public class SOAPFaultException
extends RuntimeException {
    private static Logger log = Logger.getLogger(SOAPFaultException.class);
    static final long serialVersionUID;
    private static final int CODE_IDX = 0;
    private static final int STRING_IDX = 1;
    private static final int ACTOR_IDX = 2;
    private static final int DETAIL_IDX = 3;
    private static final ObjectStreamField[] serialPersistentFields;
    private QName faultCode;
    private String faultString;
    private String faultActor;
    private Detail faultDetail;

    public SOAPFaultException(QName faultCode, String faultString, String faultActor, Detail faultDetail) {
        super(faultString);
        Name detailName = faultDetail != null ? faultDetail.getElementName() : null;
        log.debug((Object)("new SOAPFaultException [code=" + faultCode + ",string=" + faultString + ",actor=" + faultActor + ",detail=" + detailName + "]"));
        this.faultCode = faultCode;
        this.faultString = faultString;
        this.faultActor = faultActor;
        this.faultDetail = faultDetail;
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public Detail getDetail() {
        return this.faultDetail;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String name = serialPersistentFields[0].getName();
        this.faultCode = (QName)fields.get(name, null);
        name = serialPersistentFields[1].getName();
        this.faultString = (String)fields.get(name, null);
        name = serialPersistentFields[2].getName();
        this.faultActor = (String)fields.get(name, null);
        name = serialPersistentFields[3].getName();
        this.faultDetail = (Detail)fields.get(name, null);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        String name = serialPersistentFields[0].getName();
        fields.put(name, this.faultCode);
        name = serialPersistentFields[1].getName();
        fields.put(name, this.faultString);
        name = serialPersistentFields[2].getName();
        fields.put(name, this.faultActor);
        name = serialPersistentFields[3].getName();
        fields.put(name, this.faultDetail);
        oos.writeFields();
    }

    static {
        if (SerialVersion.version == 0) {
            serialVersionUID = -290987278985292477L;
            serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("faultCode", QName.class), new ObjectStreamField("faultString", String.class), new ObjectStreamField("faultActor", String.class), new ObjectStreamField("faultDetail", Detail.class)};
        } else {
            serialVersionUID = -7224636940495025621L;
            serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("faultcode", QName.class), new ObjectStreamField("faultstring", String.class), new ObjectStreamField("faultactor", String.class), new ObjectStreamField("faultdetail", Detail.class)};
        }
    }
}

