/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;

public abstract class MessageFactory {
    private static Logger log = Logger.getLogger(MessageFactory.class);
    private static final String DEFAULT_MESSAGE_FACTORY = "org.jboss.ws.soap.MessageFactoryImpl";
    private static final String[] alternativeFactories = new String[]{"org.jboss.axis.soap.MessageFactoryImpl"};

    public static MessageFactory newInstance() throws SOAPException {
        PropertyAccessAction action = new PropertyAccessAction(MessageFactory.class.getName(), DEFAULT_MESSAGE_FACTORY);
        String factoryName = (String)AccessController.doPrivileged(action);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> factoryClass = loader.loadClass(factoryName);
                return (MessageFactory)factoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                if (!factoryName.equals(DEFAULT_MESSAGE_FACTORY)) {
                    throw e;
                }
                for (int i = 0; i < alternativeFactories.length; ++i) {
                    factoryName = alternativeFactories[i];
                    try {
                        Class<?> factoryClass = loader.loadClass(factoryName);
                        return (MessageFactory)factoryClass.newInstance();
                    }
                    catch (ClassNotFoundException e1) {
                        log.debug((Object)("Cannot load factory: " + factoryName));
                        continue;
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new SOAPException("Failed to create MessageFactory: " + factoryName, t);
        }
        throw new SOAPException("Cannot find MessageFactory implementation");
    }

    public abstract SOAPMessage createMessage() throws SOAPException;

    public abstract SOAPMessage createMessage(MimeHeaders var1, InputStream var2) throws IOException, SOAPException;

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

