/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.binding.soap;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.binding.EndpointInvocation;
import org.jboss.ws.binding.UnboundHeader;
import org.jboss.ws.binding.soap.SOAPBindingProvider;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.MessageFactoryImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAP11BindingProvider
extends SOAPBindingProvider {
    private static final Logger log = Logger.getLogger(SOAP11BindingProvider.class);

    @Override
    protected SOAPMessage createMessage(OperationMetaData opMetaData) throws SOAPException {
        MessageFactoryImpl factory = new MessageFactoryImpl();
        factory.setEnvelopeURI("http://schemas.xmlsoap.org/soap/envelope/");
        return factory.createMessage();
    }

    @Override
    public SOAPMessage bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        String soapActionProperty;
        SOAPMessage reqMessage = super.bindRequestMessage(opMetaData, epInv, unboundHeaders);
        MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
        String soapAction = opMetaData.getSOAPAction();
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext.getProperty("javax.xml.rpc.soap.http.soapaction.use") != null) {
            log.info((Object)"Ignore Call.SOAPACTION_USE_PROPERTY because of BP-1.0 R2745, R2745");
        }
        if ((soapActionProperty = (String)msgContext.getProperty("javax.xml.rpc.soap.http.soapaction.uri")) != null) {
            soapAction = soapActionProperty;
        }
        mimeHeaders.addHeader("SOAPAction", soapAction != null ? soapAction : "");
        return reqMessage;
    }
}

