/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.WSException;
import org.jboss.ws.deployment.JSR109Deployment;
import org.jboss.ws.deployment.JSR109MetaDataBuilder;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedApplicationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedBeanMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedEjbPortComponentMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedWebMetaData;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.jsr109.PortComponentMetaData;
import org.jboss.ws.metadata.jsr109.WebserviceDescriptionMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSR109ServerMetaDataBuilder
extends JSR109MetaDataBuilder {
    final Logger log = Logger.getLogger(JSR109ServerMetaDataBuilder.class);

    public UnifiedMetaData buildMetaData(JSR109Deployment udi) {
        this.log.debug((Object)("START buildMetaData: [name=" + udi.getCanonicalName() + "]"));
        try {
            WebserviceDescriptionMetaData[] wsDescriptionArr;
            WSSecurityConfiguration securityConfiguration = this.getWsSecurityConfiguration(udi);
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            for (WebserviceDescriptionMetaData wsdMetaData : wsDescriptionArr = udi.getWebservicesMetaData().getWebserviceDescriptions()) {
                PortComponentMetaData[] pcMetaDataArr;
                ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, null);
                serviceMetaData.setWebserviceDescriptionName(wsdMetaData.getWebserviceDescriptionName());
                wsMetaData.addService(serviceMetaData);
                serviceMetaData.setWsdlFile(wsdMetaData.getWsdlFile());
                WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
                serviceMetaData.setJaxrpcMappingFile(wsdMetaData.getJaxrpcMappingFile());
                JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
                this.setupTypesMetaData(serviceMetaData);
                serviceMetaData.setSecurityConfiguration(securityConfiguration);
                for (PortComponentMetaData pcMetaData : pcMetaDataArr = wsdMetaData.getPortComponents()) {
                    WSDLEndpoint wsdlEndpoint;
                    QName portName = pcMetaData.getWsdlPort();
                    if (portName.getNamespaceURI().length() == 0) {
                        String nsURI = wsdlDefinitions.getTargetNamespace();
                        portName = new QName(nsURI, portName.getLocalPart());
                        this.log.warn((Object)("Adding wsdl targetNamespace to: " + portName));
                        pcMetaData.setWsdlPort(portName);
                    }
                    if ((wsdlEndpoint = this.getWsdlEndpoint(wsdlDefinitions, portName)) == null) {
                        throw new WSException("Cannot find port in wsdl: " + portName);
                    }
                    serviceMetaData.setName(wsdlEndpoint.getWsdlService().getQName());
                    ServerEndpointMetaData sepMetaData = new ServerEndpointMetaData(serviceMetaData, portName);
                    sepMetaData.setPortComponentName(pcMetaData.getPortComponentName());
                    String ejbLink = pcMetaData.getEjbLink();
                    String servletLink = pcMetaData.getServletLink();
                    sepMetaData.setLinkName(servletLink != null ? servletLink : ejbLink);
                    serviceMetaData.addEndpoint(sepMetaData);
                    this.initEndpointEncodingStyle(sepMetaData);
                    if (udi.metaData instanceof UnifiedApplicationMetaData) {
                        UnifiedEjbPortComponentMetaData bpcMetaData;
                        String configFile;
                        UnifiedApplicationMetaData apMetaData = (UnifiedApplicationMetaData)udi.metaData;
                        wsMetaData.setSecurityDomain(apMetaData.getSecurityDomain());
                        String wsdName = serviceMetaData.getWebserviceDescriptionName();
                        String wsdlPublishLocation = apMetaData.getWsdlPublishLocationByName(wsdName);
                        serviceMetaData.setWsdlPublishLocation(wsdlPublishLocation);
                        UnifiedBeanMetaData beanMetaData = apMetaData.getBeanByEjbName(ejbLink);
                        if (beanMetaData == null) {
                            throw new WSException("Cannot obtain UnifiedBeanMetaData for: " + ejbLink);
                        }
                        String configName = apMetaData.getConfigName();
                        if (configName != null) {
                            sepMetaData.setConfigName(configName);
                        }
                        if ((configFile = apMetaData.getConfigFile()) != null) {
                            sepMetaData.setConfigFile(configFile);
                        }
                        if ((bpcMetaData = beanMetaData.getPortComponent()) != null) {
                            if (bpcMetaData.getAuthMethod() != null) {
                                String authMethod = bpcMetaData.getAuthMethod();
                                sepMetaData.setAuthMethod(authMethod);
                            }
                            if (bpcMetaData.getTransportGuarantee() != null) {
                                String transportGuarantee = bpcMetaData.getTransportGuarantee();
                                sepMetaData.setTransportGuarantee(transportGuarantee);
                            }
                            sepMetaData.setURLPattern(bpcMetaData.getURLPattern());
                        }
                        this.initServicePathEJB(udi, sepMetaData, ejbLink);
                    } else if (udi.metaData instanceof UnifiedWebMetaData) {
                        String configFile;
                        UnifiedWebMetaData webMetaData = (UnifiedWebMetaData)udi.metaData;
                        wsMetaData.setSecurityDomain(webMetaData.getSecurityDomain());
                        String targetBean = webMetaData.getServletClassMap().get(servletLink);
                        sepMetaData.setServiceEndpointImplName(targetBean);
                        String wsdName = serviceMetaData.getWebserviceDescriptionName();
                        String wsdlPublishLocation = webMetaData.getWsdlPublishLocationByName(wsdName);
                        serviceMetaData.setWsdlPublishLocation(wsdlPublishLocation);
                        String configName = webMetaData.getConfigName();
                        if (configName != null) {
                            sepMetaData.setConfigName(configName);
                        }
                        if ((configFile = webMetaData.getConfigFile()) != null) {
                            sepMetaData.setConfigFile(configFile);
                        }
                        this.initServicePathJSE(udi, sepMetaData, servletLink);
                        this.initTransportGuaranteeJSE(udi, sepMetaData, servletLink);
                    }
                    ObjectName sepID = this.getServiceEndpointID(udi, sepMetaData);
                    sepMetaData.setServiceEndpointID(sepID);
                    this.replaceAddressLocation(sepMetaData);
                    String seiName = pcMetaData.getServiceEndpointInterface();
                    sepMetaData.setServiceEndpointInterfaceName(seiName);
                    ServiceEndpointInterfaceMapping seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMapping(seiName);
                    if (seiMapping == null) {
                        this.log.warn((Object)("Cannot obtain SEI mapping for: " + seiName));
                    }
                    this.processEndpointMetaDataExtensions(sepMetaData, wsdlDefinitions);
                    this.setupOperationsFromWSDL(sepMetaData, wsdlEndpoint, seiMapping);
                    for (UnifiedHandlerMetaData handlerMetaData : pcMetaData.getHandlers()) {
                        List<String> portNames = Arrays.asList(handlerMetaData.getPortNames());
                        if (portNames.size() != 0 && !portNames.contains(portName.getLocalPart())) continue;
                        sepMetaData.addHandler(handlerMetaData);
                    }
                }
            }
            this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    private WSDLEndpoint getWsdlEndpoint(WSDLDefinitions wsdlDefinitions, QName portName) {
        WSDLEndpoint wsdlEndpoint = null;
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            WSDLEndpoint auxEndpoint = wsdlService.getEndpoint(portName);
            if (auxEndpoint == null) continue;
            wsdlEndpoint = auxEndpoint;
            break;
        }
        return wsdlEndpoint;
    }

    private void initServicePathEJB(UnifiedDeploymentInfo udi, ServerEndpointMetaData epMetaData, String ejbLink) {
        UnifiedApplicationMetaData applMetaData = (UnifiedApplicationMetaData)udi.metaData;
        UnifiedBeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbLink);
        if (beanMetaData == null) {
            throw new WSException("Cannot obtain meta data for ejb link: " + ejbLink);
        }
        String contextRoot = applMetaData.getWebServiceContextRoot();
        if (contextRoot == null) {
            String shortName = udi.shortName;
            contextRoot = shortName.substring(0, shortName.indexOf(46));
            contextRoot = "/" + contextRoot;
        }
        epMetaData.setContextRoot(contextRoot);
        UnifiedEjbPortComponentMetaData ejbpcMetaData = beanMetaData.getPortComponent();
        String urlPattern = ejbpcMetaData != null && ejbpcMetaData.getPortComponentURI() != null ? ejbpcMetaData.getPortComponentURI() : "/" + ejbLink;
        epMetaData.setURLPattern(urlPattern);
    }

    private void initServicePathJSE(UnifiedDeploymentInfo udi, ServerEndpointMetaData epMetaData, String servletLink) {
        UnifiedWebMetaData webMetaData = (UnifiedWebMetaData)udi.metaData;
        Map<String, String> servletMappings = webMetaData.getServletMappings();
        String contextRoot = webMetaData.getContextRoot();
        if (contextRoot == null) {
            String shortName = udi.shortName;
            contextRoot = shortName.substring(0, shortName.indexOf(46));
            contextRoot = "/" + contextRoot;
        }
        epMetaData.setContextRoot(contextRoot);
        String urlPattern = servletMappings.get(servletLink);
        if (urlPattern == null) {
            throw new WSException("Cannot obtain servlet mapping for servlet link: " + servletLink);
        }
        if (!urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        epMetaData.setURLPattern(urlPattern);
    }

    protected void initTransportGuaranteeJSE(UnifiedDeploymentInfo udi, EndpointMetaData epMetaData, String servletLink) throws IOException {
        File warFile = new File(udi.localUrl.getFile());
        if (!warFile.isDirectory()) {
            throw new WSException("Expected a war directory: " + udi.localUrl);
        }
        File webXML = new File(udi.localUrl.getFile() + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new WSException("Cannot find web.xml: " + webXML);
        }
        Element rootElement = DOMUtils.parse((InputStream)new FileInputStream(webXML));
        Element elServletMapping = null;
        Iterator itServlet = DOMUtils.getChildElements((Node)rootElement, (String)"servlet-mapping");
        while (itServlet.hasNext() && elServletMapping == null) {
            Element elAux = (Element)itServlet.next();
            String servletName = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elAux, (String)"servlet-name"));
            if (!servletLink.equals(servletName)) continue;
            elServletMapping = elAux;
        }
        if (elServletMapping != null) {
            String urlPattern = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement(elServletMapping, (String)"url-pattern"));
            if (urlPattern == null) {
                throw new WSException("Cannot find <url-pattern> for servlet-name: " + servletLink);
            }
            Iterator itSecConstraint = DOMUtils.getChildElements((Node)rootElement, (String)"security-constraint");
            while (itSecConstraint.hasNext()) {
                Element elSecurityConstraint = (Element)itSecConstraint.next();
                Iterator itWebResourceCollection = DOMUtils.getChildElements((Node)elSecurityConstraint, (String)"web-resource-collection");
                while (itWebResourceCollection.hasNext()) {
                    Element elUserDataConstraint;
                    Element elWebResourceCollection = (Element)itWebResourceCollection.next();
                    String wrcurlPattern = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elWebResourceCollection, (String)"url-pattern"));
                    if (!urlPattern.equals(wrcurlPattern) || (elUserDataConstraint = DOMUtils.getFirstChildElement((Node)elSecurityConstraint, (String)"user-data-constraint")) == null) continue;
                    String transportGuarantee = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elUserDataConstraint, (String)"transport-guarantee"));
                    epMetaData.setTransportGuarantee(transportGuarantee);
                }
            }
        }
    }
}

