/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.deployment;

import java.util.Map;
import javax.jws.WebService;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.deployment.JSR181MetaDataBuilder;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedWebMetaData;

public class JSR181MetaDataBuilderJSE
extends JSR181MetaDataBuilder {
    private final Logger log = Logger.getLogger(JSR181MetaDataBuilderJSE.class);

    public UnifiedMetaData buildMetaData(UnifiedDeploymentInfo udi) {
        this.log.debug((Object)("START buildMetaData: [name=" + udi.getCanonicalName() + "]"));
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            if (udi.annotationsCl == null) {
                throw new WSException("Annotations class loader not initialized");
            }
            UnifiedWebMetaData webMetaData = (UnifiedWebMetaData)udi.metaData;
            Map<String, String> servletClassMap = webMetaData.getServletClassMap();
            for (String servletName : servletClassMap.keySet()) {
                String servletClassName = servletClassMap.get(servletName);
                try {
                    Class<?> beanClass = udi.annotationsCl.loadClass(servletClassName);
                    if (!beanClass.isAnnotationPresent(WebService.class)) continue;
                    this.setupEndpointFromAnnotations(wsMetaData, udi, beanClass, servletName);
                }
                catch (ClassNotFoundException ex) {
                    this.log.warn((Object)("Cannot load service endpoint class: " + servletClassName));
                }
            }
            this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }
}

