/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.deployment;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.deployment.AbstractMetaDataBuilder;
import org.jboss.ws.deployment.JSR109Deployment;
import org.jboss.ws.deployment.JSR109ServerMetaDataBuilder;
import org.jboss.ws.deployment.JSR181MetaDataBuilderEJB21;
import org.jboss.ws.deployment.JSR181MetaDataBuilderEJB3;
import org.jboss.ws.deployment.JSR181MetaDataBuilderJSE;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.server.ServiceEndpointInfo;
import org.jboss.ws.server.ServiceEndpointManager;
import org.jboss.ws.server.WSDLFilePublisher;

public class ServiceEndpointDeployer {
    private static Logger log = Logger.getLogger(ServiceEndpointDeployer.class);
    public static final String BEAN_NAME = "ServiceEndpointDeployer";
    public static final String INIT_PARAM_SERVICE_ENDPOINT_IMPL = "ServiceEndpointImpl";
    private ServiceEndpointManager epManager;
    private Map<String, UnifiedMetaData> metaDataMap = new ConcurrentHashMap<String, UnifiedMetaData>();

    public void setServiceEndpointManager(ServiceEndpointManager epManager) {
        this.epManager = epManager;
    }

    public void create(UnifiedDeploymentInfo udi) throws Throwable {
        UnifiedMetaData wsMetaData;
        AbstractMetaDataBuilder builder;
        log.debug((Object)("create: " + udi.url));
        if (udi.type == UnifiedDeploymentInfo.Type.JSR109_JSE) {
            builder = new JSR109ServerMetaDataBuilder();
            builder.setClassLoader(null);
            builder.setResourceLoader(udi.localCl);
            wsMetaData = ((JSR109ServerMetaDataBuilder)builder).buildMetaData((JSR109Deployment)udi);
        } else if (udi.type == UnifiedDeploymentInfo.Type.JSR109_EJB21) {
            builder = new JSR109ServerMetaDataBuilder();
            builder.setClassLoader(udi.ucl);
            builder.setResourceLoader(udi.localCl);
            wsMetaData = ((JSR109ServerMetaDataBuilder)builder).buildMetaData((JSR109Deployment)udi);
        } else if (udi.type == UnifiedDeploymentInfo.Type.JSR181_JSE) {
            builder = new JSR181MetaDataBuilderJSE();
            builder.setClassLoader(udi.annotationsCl);
            builder.setResourceLoader(udi.localCl);
            wsMetaData = ((JSR181MetaDataBuilderJSE)builder).buildMetaData(udi);
        } else if (udi.type == UnifiedDeploymentInfo.Type.JSR181_EJB21) {
            builder = new JSR181MetaDataBuilderEJB21();
            builder.setClassLoader(udi.annotationsCl);
            builder.setResourceLoader(udi.localCl);
            wsMetaData = ((JSR181MetaDataBuilderEJB21)builder).buildMetaData(udi);
        } else if (udi.type == UnifiedDeploymentInfo.Type.JSR181_EJB3) {
            builder = new JSR181MetaDataBuilderEJB3();
            builder.setClassLoader(udi.annotationsCl);
            builder.setResourceLoader(udi.localCl);
            wsMetaData = ((JSR181MetaDataBuilderEJB3)builder).buildMetaData(udi);
        } else {
            throw new WSException("Invalid type:  " + (Object)((Object)udi.type));
        }
        this.metaDataMap.put(udi.url.toExternalForm(), wsMetaData);
        for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
            for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                ServiceEndpointInfo seInfo = new ServiceEndpointInfo(udi, (ServerEndpointMetaData)epMetaData);
                this.epManager.createServiceEndpoint(seInfo);
            }
        }
    }

    public void start(UnifiedDeploymentInfo udi) throws Throwable {
        log.debug((Object)("start: " + udi.url));
        UnifiedMetaData wsMetaData = this.getUnifiedMetaData(udi);
        if (wsMetaData != null) {
            if (wsMetaData.getClassLoader() != udi.ucl) {
                wsMetaData.setClassLoader(udi.ucl);
            }
            WSDLFilePublisher wsdlfp = new WSDLFilePublisher(udi);
            wsdlfp.publishWsdlFiles(wsMetaData);
            for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
                for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                    ObjectName sepID = ((ServerEndpointMetaData)epMetaData).getServiceEndpointID();
                    this.epManager.startServiceEndpoint(sepID);
                }
            }
        }
    }

    public void stop(UnifiedDeploymentInfo udi) throws Throwable {
        log.debug((Object)("stop: " + udi.url));
        UnifiedMetaData wsMetaData = this.getUnifiedMetaData(udi);
        if (wsMetaData != null) {
            for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
                for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                    ObjectName sepID = ((ServerEndpointMetaData)epMetaData).getServiceEndpointID();
                    this.epManager.stopServiceEndpoint(sepID);
                }
            }
            WSDLFilePublisher wsdlfp = new WSDLFilePublisher(udi);
            wsdlfp.unpublishWsdlFiles();
        }
    }

    public void destroy(UnifiedDeploymentInfo udi) throws Throwable {
        log.debug((Object)("destroy: " + udi.url));
        UnifiedMetaData wsMetaData = this.getUnifiedMetaData(udi);
        if (wsMetaData != null) {
            for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
                for (EndpointMetaData epMetaData : serviceMetaData.getEndpoints()) {
                    ObjectName sepID = ((ServerEndpointMetaData)epMetaData).getServiceEndpointID();
                    this.epManager.destroyServiceEndpoint(sepID);
                }
            }
        }
    }

    public UnifiedMetaData getUnifiedMetaData(UnifiedDeploymentInfo udi) {
        UnifiedMetaData wsMetaData = this.metaDataMap.get(udi.url.toExternalForm());
        return wsMetaData;
    }
}

