/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.deployment.ServiceEndpointDeployer;
import org.jboss.ws.deployment.UnifiedDeploymentInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceEndpointPublisher {
    public static final String BEAN_NAME = "ServiceEndpointPublisher";
    public static final String INIT_PARAM_SERVICE_ENDPOINT_IMPL = "ServiceEndpointImpl";
    private static Logger log = Logger.getLogger(ServiceEndpointPublisher.class);
    protected ServiceEndpointDeployer serviceEndpointDeployer;
    protected String servletName;

    public ServiceEndpointDeployer getServiceEndpointDeployer() {
        return this.serviceEndpointDeployer;
    }

    public void setServiceEndpointDeployer(ServiceEndpointDeployer serviceEndpointDeployer) {
        this.serviceEndpointDeployer = serviceEndpointDeployer;
    }

    public String getServiceEndpointServlet() {
        return this.servletName;
    }

    public void setServiceEndpointServlet(String servletName) {
        this.servletName = servletName;
    }

    public abstract String publishServiceEndpoint(URL var1) throws Exception;

    public abstract String destroyServiceEndpoint(URL var1) throws Exception;

    public abstract String publishServiceEndpoint(UnifiedDeploymentInfo var1) throws Exception;

    public abstract String destroyServiceEndpoint(UnifiedDeploymentInfo var1) throws Exception;

    public Map<String, String> rewriteWebXML(URL warURL) {
        File warFile = new File(warURL.getFile());
        if (!warFile.isDirectory()) {
            throw new WSException("Expected a war directory: " + warURL);
        }
        File webXML = new File(warURL.getFile() + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new WSException("Cannot find web.xml: " + webXML);
        }
        try {
            Element root = DOMUtils.parse((InputStream)new FileInputStream(webXML));
            String warName = warFile.getName();
            Map<String, String> sepTargetMap = this.modifyServletConfig(root, warName);
            File orgWebXML = new File(webXML.getCanonicalPath() + ".org");
            orgWebXML.delete();
            if (!webXML.renameTo(orgWebXML)) {
                throw new WSException("Cannot rename web.xml: " + orgWebXML);
            }
            FileOutputStream fos = new FileOutputStream(webXML);
            new DOMWriter((OutputStream)fos).setPrettyprint(true).print((Node)root);
            fos.close();
            return sepTargetMap;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException(e);
        }
    }

    private Map<String, String> modifyServletConfig(Element root, String warName) {
        HashMap<String, String> sepTargetMap = new HashMap<String, String>();
        Iterator itServlets = DOMUtils.getChildElements((Node)root, (String)"servlet");
        while (itServlets.hasNext()) {
            Element servletElement = (Element)itServlets.next();
            String linkName = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)servletElement, (String)"servlet-name"));
            Element classElement = DOMUtils.getFirstChildElement((Node)servletElement, (String)"servlet-class");
            if (classElement == null) {
                throw new WSException("Cannot find <servlet-class> for servlet-name: " + linkName);
            }
            String servletClassName = DOMUtils.getTextContent((Node)classElement);
            String targetBeanName = null;
            if (!this.isAlreadyModified(servletElement)) {
                if (servletClassName.endsWith("Servlet")) {
                    log.info((Object)("Ignore <servlet-class> that ends with 'Servlet': " + servletClassName));
                    continue;
                }
                boolean startDetach = false;
                ArrayList<Element> detachedElements = new ArrayList<Element>();
                Iterator itDetached = DOMUtils.getChildElements((Node)servletElement);
                while (itDetached.hasNext()) {
                    Element el = (Element)itDetached.next();
                    if (startDetach) {
                        detachedElements.add(el);
                        servletElement.removeChild(el);
                    }
                    if (!el.equals(classElement)) continue;
                    servletElement.removeChild(el);
                    startDetach = true;
                }
                classElement = DOMUtils.createElement((String)"servlet-class");
                classElement.appendChild(DOMUtils.createTextNode((String)this.servletName));
                classElement = (Element)servletElement.getOwnerDocument().importNode(classElement, true);
                servletElement.appendChild(classElement);
                if (!servletClassName.equals(this.servletName)) {
                    Element paramElement = DOMUtils.createElement((String)"init-param");
                    paramElement.appendChild(DOMUtils.createElement((String)"param-name")).appendChild(DOMUtils.createTextNode((String)INIT_PARAM_SERVICE_ENDPOINT_IMPL));
                    paramElement.appendChild(DOMUtils.createElement((String)"param-value")).appendChild(DOMUtils.createTextNode((String)servletClassName));
                    paramElement = (Element)servletElement.getOwnerDocument().importNode(paramElement, true);
                    servletElement.appendChild(paramElement);
                    targetBeanName = servletClassName;
                }
                for (Element el : detachedElements) {
                    servletElement.appendChild(el);
                }
            } else {
                Iterator itParams = DOMUtils.getChildElements((Node)servletElement, (String)"init-param");
                while (itParams.hasNext()) {
                    Element elParam = (Element)itParams.next();
                    Element elParamName = DOMUtils.getFirstChildElement((Node)elParam, (String)"param-name");
                    Element elParamValue = DOMUtils.getFirstChildElement((Node)elParam, (String)"param-value");
                    if (!INIT_PARAM_SERVICE_ENDPOINT_IMPL.equals(DOMUtils.getTextContent((Node)elParamName))) continue;
                    targetBeanName = DOMUtils.getTextContent((Node)elParamValue);
                }
            }
            if (targetBeanName == null) {
                throw new IllegalStateException("Cannot obtain service endpoint bean for: " + linkName);
            }
            sepTargetMap.put(linkName, targetBeanName.trim());
        }
        return sepTargetMap;
    }

    private boolean isAlreadyModified(Element servletElement) {
        Iterator itParams = DOMUtils.getChildElements((Node)servletElement, (String)"init-param");
        while (itParams.hasNext()) {
            Element elParam = (Element)itParams.next();
            Element elParamName = DOMUtils.getFirstChildElement((Node)elParam, (String)"param-name");
            if (!INIT_PARAM_SERVICE_ENDPOINT_IMPL.equals(DOMUtils.getTextContent((Node)elParamName))) continue;
            return true;
        }
        return false;
    }
}

