/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.mgmt;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;
import org.jboss.ws.WSException;
import org.jboss.ws.eventing.deployment.EventingEndpointDI;
import org.jboss.ws.eventing.element.EndpointReference;
import org.jboss.ws.eventing.element.ReferenceParameters;
import org.jboss.ws.eventing.mgmt.DispatchJob;
import org.jboss.ws.eventing.mgmt.DispatcherDelegate;
import org.jboss.ws.eventing.mgmt.EventDispatcher;
import org.jboss.ws.eventing.mgmt.EventSource;
import org.jboss.ws.eventing.mgmt.EventingBuilder;
import org.jboss.ws.eventing.mgmt.Filter;
import org.jboss.ws.eventing.mgmt.Subscription;
import org.jboss.ws.eventing.mgmt.SubscriptionError;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.eventing.mgmt.SubscriptionTicket;
import org.jboss.ws.utils.ObjectNameFactory;
import org.jboss.ws.utils.UUIDGenerator;
import org.w3c.dom.Element;

public class SubscriptionManager
implements SubscriptionManagerMBean,
EventDispatcher {
    private static final Logger log = Logger.getLogger(SubscriptionManager.class);
    public static final ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss.ws:service=SubscriptionManager,module=eventing");
    private ConcurrentMap<URI, EventSource> eventSourceMapping = new ConcurrentHashMap<URI, EventSource>();
    private ConcurrentMap<URI, List<Subscription>> subscriptionMapping = new ConcurrentHashMap<URI, List<Subscription>>();
    private BlockingQueue<Runnable> eventQueue = new LinkedBlockingQueue<Runnable>();
    private ThreadPoolExecutor threadPool;
    private boolean isDispatcherBound = false;
    private WatchDog watchDog;
    private static EventingBuilder builder = EventingBuilder.createEventingBuilder();

    public void create() throws Exception {
        MBeanServer server = this.getJMXServer();
        if (server != null) {
            log.debug((Object)"Create subscription manager");
            server.registerMBean(this, OBJECT_NAME);
        }
    }

    public void destroy() throws Exception {
        MBeanServer server = this.getJMXServer();
        if (server != null) {
            log.debug((Object)"Destroy subscription manager");
            server.unregisterMBean(OBJECT_NAME);
        }
    }

    public void start() throws Exception {
        log.debug((Object)"Start subscription manager");
        this.threadPool = new ThreadPoolExecutor(5, 15, 5000L, TimeUnit.MILLISECONDS, this.eventQueue);
        this.watchDog = new WatchDog(this.subscriptionMapping);
        this.watchDog.startup();
    }

    public void stop() {
        log.debug((Object)"Stop subscription manager");
        try {
            Util.unbind((Context)new InitialContext(), (String)"EventDispatcher");
            this.threadPool.shutdown();
            this.watchDog.shutdown();
            for (URI eventSourceNS : this.eventSourceMapping.keySet()) {
                this.removeEventSource(eventSourceNS);
            }
        }
        catch (NamingException e) {
            log.debug((Object)("Cannot unbind event dispatcher: " + e.toString()));
        }
    }

    private static URI generateSubscriptionID() {
        try {
            return new URI("urn:jbwse:" + UUIDGenerator.generateRandomUUIDString());
        }
        catch (URISyntaxException e) {
            throw new WSException(e.getMessage());
        }
    }

    public void registerEventSource(EventingEndpointDI deploymentInfo) {
        this.lazyBindEventDispatcher();
        EventSource eventSource = builder.newEventSource(deploymentInfo);
        if (!this.eventSourceMapping.containsKey(eventSource.getNameSpace())) {
            this.eventSourceMapping.put(eventSource.getNameSpace(), eventSource);
            SubscriptionManager.updateManagerAddress(deploymentInfo, eventSource);
            eventSource.setState(EventSource.State.CREATED);
            log.debug((Object)("Created: " + eventSource));
        } else {
            eventSource = (EventSource)this.eventSourceMapping.get(eventSource.getNameSpace());
            SubscriptionManager.updateManagerAddress(deploymentInfo, eventSource);
            this.subscriptionMapping.put(eventSource.getNameSpace(), new CopyOnWriteArrayList());
            eventSource.setState(EventSource.State.STARTED);
            log.debug((Object)("Started: " + eventSource));
        }
    }

    private void lazyBindEventDispatcher() {
        if (!this.isDispatcherBound) {
            try {
                Util.rebind((Context)new InitialContext(), (String)"EventDispatcher", (Object)new DispatcherDelegate("localhost"));
                log.info((Object)"Bound event dispatcher to java:/EventDispatcher");
                this.isDispatcherBound = true;
            }
            catch (NamingException e) {
                throw new WSException("Unable to bind EventDispatcher ", e);
            }
        }
    }

    private static void updateManagerAddress(EventingEndpointDI deploymentInfo, EventSource eventSource) {
        String addr = null;
        if (deploymentInfo.getPortName().equals("SubscriptionManagerPort")) {
            addr = deploymentInfo.getEndpointAddress();
        }
        if (addr != null) {
            eventSource.setManagerAddress(addr);
        }
    }

    public void removeEventSource(URI eventSourceNS) {
        if (this.eventSourceMapping.containsKey(eventSourceNS)) {
            List subscriptions = (List)this.subscriptionMapping.get(eventSourceNS);
            for (Subscription s : subscriptions) {
                s.end("http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceShuttingDown");
            }
            subscriptions.clear();
            this.eventSourceMapping.remove(eventSourceNS);
            log.debug((Object)("Event source " + eventSourceNS + " removed"));
        }
    }

    public SubscriptionTicket subscribe(URI eventSourceNS, EndpointReference notifyTo, EndpointReference endTo, Date expires, Filter filter) throws SubscriptionError {
        log.debug((Object)("Subscription request for " + eventSourceNS));
        EventSource eventSource = (EventSource)this.eventSourceMapping.get(eventSourceNS);
        if (null == eventSource) {
            throw new SubscriptionError("EventSourceUnableToProcess", "EventSource '" + eventSourceNS + "' not registered");
        }
        if (expires != null) {
            this.assertLeaseConstraints(expires);
        } else {
            expires = new Date(System.currentTimeMillis() + 300000L);
        }
        if (filter != null) {
            if (eventSource.getSupportedFilterDialects().isEmpty()) {
                throw new SubscriptionError("FilteringNotSupported", "Filtering is not supported.");
            }
            boolean filterAvailable = false;
            for (URI supportedDialect : eventSource.getSupportedFilterDialects()) {
                if (!filter.getDialect().equals(supportedDialect)) continue;
                filterAvailable = true;
                break;
            }
            if (!filterAvailable) {
                throw new SubscriptionError("FilteringRequestedUnavailable", "The requested filter dialect is not supported.");
            }
        }
        EndpointReference endpointReference = new EndpointReference();
        endpointReference.setAddress(eventSource.getManagerAddress());
        endpointReference.setReferenceParams(new ReferenceParameters(SubscriptionManager.generateSubscriptionID()));
        Subscription subscription = new Subscription(eventSource.getNameSpace(), endpointReference, notifyTo, endTo, expires, filter);
        ((List)this.subscriptionMapping.get(eventSourceNS)).add(subscription);
        log.debug((Object)("Registered subscription " + subscription.getIdentifier()));
        return new SubscriptionTicket(endpointReference, subscription.getExpires());
    }

    private void assertLeaseConstraints(Date expireDate) throws SubscriptionError {
        long expires = expireDate.getTime() - System.currentTimeMillis();
        if (expires < 0L || 600000L < expires) {
            throw new SubscriptionError("InvalidExpirationTime", "The expiration time requested is invalid: " + expires + "ms");
        }
    }

    public Date renew(URI identifier, Date lease) throws SubscriptionError {
        Subscription subscription = this.subscriberForID(identifier);
        if (null == subscription) {
            throw new SubscriptionError("UnableToRenew", "Subscription " + identifier + " does not exist");
        }
        if (lease != null) {
            this.assertLeaseConstraints(lease);
        } else {
            lease = new Date(System.currentTimeMillis() + 300000L);
        }
        subscription.setExpires(lease);
        return lease;
    }

    public final Date getStatus(URI identifier) throws SubscriptionError {
        Subscription subscription = this.subscriberForID(identifier);
        if (null == subscription) {
            throw new SubscriptionError("EventSourceUnableToProcess", "Subscription " + identifier + " does not exist");
        }
        return subscription.getExpires();
    }

    public void unsubscribe(URI identifier) throws SubscriptionError {
        block0: for (List subscriptions : this.subscriptionMapping.values()) {
            for (Subscription s : subscriptions) {
                if (!identifier.equals(s.getIdentifier())) continue;
                subscriptions.remove(s);
                log.debug((Object)("Removed subscription " + s));
                continue block0;
            }
        }
    }

    public String showEventsourceTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Deployed Eventsources</h3>");
        pw.println("<table>");
        pw.println("<tr><td>Name</td><td>NS</td></tr>");
        for (EventSource source : this.eventSourceMapping.values()) {
            pw.println("<tr><td>" + source.getName() + "</td><td>" + source.getNameSpace() + "</td></tr>");
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    public String showSubscriptionTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Registered Subscriptions</h3>");
        pw.println("<table>");
        pw.println("<tr><td>Identifier</td><td>Expires</td><td>Filter</td></tr>");
        for (List subscriptions : this.subscriptionMapping.values()) {
            for (Subscription s : subscriptions) {
                pw.println("<tr><td>" + s.getIdentifier() + "</td><td>" + s.getExpires() + "</td><td>" + s.getFilter().getExpression() + "</td></tr>");
            }
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    private Subscription subscriberForID(URI id) {
        Subscription subscription = null;
        block0: for (List subscriptions : this.subscriptionMapping.values()) {
            for (Subscription s : subscriptions) {
                if (!id.equals(s.getIdentifier())) continue;
                subscription = s;
                continue block0;
            }
        }
        return subscription;
    }

    public void dispatch(URI eventSourceNS, Element payload) {
        DispatchJob dispatchJob = new DispatchJob(eventSourceNS, payload, this.subscriptionMapping);
        this.threadPool.execute(dispatchJob);
    }

    public int getCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    public int getMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public int getLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    public long getCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.threadPool.setCorePoolSize(corePoolSize);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.threadPool.setMaximumPoolSize(maxPoolSize);
    }

    public void setEventKeepAlive(long millies) {
        this.threadPool.setKeepAliveTime(millies, TimeUnit.MILLISECONDS);
    }

    private MBeanServer getJMXServer() {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.size() > 0) {
            server = servers.get(0);
        }
        return server;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WatchDog
    implements Runnable {
        private ConcurrentMap<URI, List<Subscription>> subscriptions;
        private boolean active = true;
        private Thread worker;

        public WatchDog(ConcurrentMap<URI, List<Subscription>> subscriptions) {
            this.subscriptions = subscriptions;
        }

        @Override
        public void run() {
            while (this.active) {
                for (List subscriptions : SubscriptionManager.this.subscriptionMapping.values()) {
                    for (Subscription s : subscriptions) {
                        if (!s.isExpired()) continue;
                        s.end("http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceCanceling");
                        subscriptions.remove(s);
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
        }

        public void startup() {
            this.worker = new Thread((Runnable)this, "SubscriptionWatchDog");
            this.worker.start();
        }

        public void shutdown() {
            this.active = false;
        }
    }
}

