/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxb;

import java.io.InputStream;
import java.util.HashMap;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxb.JAXBUnmarshaller;
import org.jboss.ws.jaxb.JBossXBSupport;
import org.jboss.ws.jaxb.UnmarshalException;
import org.jboss.ws.xop.XOPUnmarshallerImpl;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;

public class JBossXBUnmarshallerImpl
implements JAXBUnmarshaller {
    private HashMap<String, Object> properties = new HashMap();

    public Object unmarshal(InputStream is) throws UnmarshalException {
        this.assertRequiredProperties();
        Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        SchemaBinding schemaBinding = JBossXBSupport.getOrCreateSchemaBinding(this.properties);
        schemaBinding.setXopUnmarshaller((XOPUnmarshaller)new XOPUnmarshallerImpl());
        try {
            return unm.unmarshal(is, schemaBinding);
        }
        catch (JBossXBException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        this.properties.put(name, value);
    }

    private void assertRequiredProperties() {
        if (this.getProperty("org.jboss.jaxb.xsd.xsmodel") == null) {
            throw new WSException("Cannot find required property: org.jboss.jaxb.xsd.xsmodel");
        }
        if (this.getProperty("org.jboss.jaxb.java.mapping") == null) {
            throw new WSException("Cannot find required property: org.jboss.jaxb.java.mapping");
        }
    }
}

